/* Generated By:JavaCC: Do not edit this line. ASPCore2Visitor.java Version 5.0 */
/*
 *  This file is part of "TweetyProject", a collection of Java libraries for
 *  logical aspects of artificial intelligence and knowledge representation.
 *
 *  TweetyProject is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  Copyright 2018 The TweetyProject Team <http://tweetyproject.org/contact/>
 */
package org.tweetyproject.lp.asp.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.tweetyproject.logics.commons.syntax.Constant;
import org.tweetyproject.logics.commons.syntax.FunctionalTerm;
import org.tweetyproject.logics.commons.syntax.Functor;
import org.tweetyproject.logics.commons.syntax.NumberTerm;
import org.tweetyproject.logics.commons.syntax.Predicate;
import org.tweetyproject.logics.commons.syntax.Variable;
import org.tweetyproject.logics.commons.syntax.interfaces.Term;
import org.tweetyproject.lp.asp.semantics.AnswerSet;
import org.tweetyproject.lp.asp.syntax.ASPAtom;
import org.tweetyproject.lp.asp.syntax.ClassicalHead;
import org.tweetyproject.lp.asp.syntax.ASPLiteral;
import org.tweetyproject.lp.asp.syntax.ASPBodyElement;
import org.tweetyproject.lp.asp.syntax.ASPHead;
import org.tweetyproject.lp.asp.syntax.StrictNegation;
import org.tweetyproject.lp.asp.syntax.ASPOperator;
import org.tweetyproject.lp.asp.syntax.ASPRule;
import org.tweetyproject.lp.asp.syntax.AggregateAtom;
import org.tweetyproject.lp.asp.syntax.AggregateElement;
import org.tweetyproject.lp.asp.syntax.AggregateHead;
import org.tweetyproject.lp.asp.syntax.ArithmeticTerm;
import org.tweetyproject.lp.asp.syntax.ChoiceElement;
import org.tweetyproject.lp.asp.syntax.ChoiceHead;
import org.tweetyproject.lp.asp.syntax.ComparativeAtom;
import org.tweetyproject.lp.asp.syntax.DefaultNegation;
import org.tweetyproject.lp.asp.syntax.OptimizationElement;
import org.tweetyproject.lp.asp.syntax.OptimizationStatement;
import org.tweetyproject.lp.asp.syntax.Program;

/**
 * This visitor iterates over the AST generated by ASPParser and allocates
 * classes representing the different parts of an ASP program or source file,
 * meaning rules, literals, terms, answer sets, etc.
 *
 * @see org.tweetyproject.lp.asp.parser.ASPParser
 * @author Anna Gessler
 *
 */
public class InstantiateVisitor implements ASPParserVisitor {
	/**
	 * List of predicates that is used to represent Clingo #show statements.
	 */
	private Set<Predicate> predicates_whitelist = new HashSet<Predicate>();

	/**
	 * List of additional parsed options.
	 */
	private Set<String> options = new HashSet<String>();

	@Override
	public Object visit(SimpleNode node, Object data) {
		throw new RuntimeException();
	}

	@Override
	public AnswerSet visit(ASTAnswerSet node, Object data) {
		AnswerSet as = new AnswerSet();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTLiteral) {
				ASPLiteral a = visit((ASTLiteral) node.jjtGetChild(i), null);
				as.add(a);
			}
		}
		return as;
	}

	@Override
	public Program visit(ASTProgram node, Object data) {
		predicates_whitelist = new HashSet<Predicate>();
		Program p = new Program();
		try {
			for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
				if (node.jjtGetChild(i) instanceof ASTRuleList) {
					List<ASPRule> rules = visit((ASTRuleList) node.jjtGetChild(i), null);
					p.addAll(rules);
				} else if (node.jjtGetChild(i) instanceof ASTQuery) {
					if (!p.hasQuery()) {
						ASPLiteral q = visit((ASTQuery) node.jjtGetChild(i), null);
						p.setQuery(q);
					} else
						throw new ParseException(
								"Error: Multiple queries found. There can only be one query per program.");
				}
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}

		p.setOutputWhitelist(predicates_whitelist);
		p.setAdditionalOptions(options);
		return p;
	}

	@Override
	public ASPLiteral visit(ASTQuery node, Object data) {
		ASPLiteral atom = null;
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTLiteral)
				atom = visit((ASTLiteral) node.jjtGetChild(i), null);
		}
		return atom;
	}

	@Override
	public List<ASPRule> visit(ASTRuleList node, Object data) {
		List<ASPRule> elements = new ArrayList<ASPRule>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTRule) {
				ASPRule a = visit((ASTRule) node.jjtGetChild(i), null);
				if (!a.isEmpty())
					elements.add(a);
			}
		}
		return elements;
	}

	@Override
	public ASPRule visit(ASTRule node, Object data) {
		ASPHead head = new ClassicalHead();
		// if (node.jjtGetChild(0) instanceof ASTAggregate) {
		// AggregateAtom aggregate = visit((ASTAggregate) node.jjtGetChild(0), null);
		// head = new AggregateHead(aggregate);
		// }
		// else if (node.jjtGetChild(0) instanceof ASTChoice) {
		// ChoiceHead choice = visit((ASTChoice) node.jjtGetChild(0), null);
		// head = choice;
		// }
		// else
		// head = new ClassicalHead();
		List<ASPBodyElement> body = new LinkedList<ASPBodyElement>();
		Term<?> weight = null;
		Term<?> level = null;
		List<Term<?>> rightTerms = new ArrayList<Term<?>>();

		if (node.jjtGetChild(0) instanceof ASTOpt)
			return visit((ASTOpt) node.jjtGetChild(0), null);

		if (node.jjtGetChild(0) instanceof ASTHead)
			head = visit((ASTHead) node.jjtGetChild(0), null);

		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTBodyList) {
				body = visit((ASTBodyList) node.jjtGetChild(i), null);
			} else if (node.jjtGetChild(i) instanceof ASTWeight) {
				// the visit method for ASTWeight returns a list of all terms to
				// the right of the rule body. The first term in the list
				// is the weight. If there is a level, it is the second
				// term in the list.
				rightTerms = visit((ASTWeight) node.jjtGetChild(i), null);
				weight = rightTerms.remove(0);
				if (((ASTWeight) node.jjtGetChild(i)).hasLevel)
					level = rightTerms.remove(0);
			} else if (node.jjtGetChild(i) instanceof ASTClingoMeta) {
				String cm = visit((ASTClingoMeta) node.jjtGetChild(i), null);
				if (cm.startsWith("#show")) {
					String cmTrimmed = cm.substring(6).trim();
					String[] s = cmTrimmed.split("/");
					Predicate pw = new Predicate(s[0], Integer.parseInt(s[1].substring(0, s[1].length())));
					this.predicates_whitelist.add(pw);
				} else if (cm.startsWith("#maxint")) {
					this.options.add(cm);
				} else if (cm.startsWith("#const")) {
					this.options.add(cm);
				}
				// other meta statements are currently not supported (ignored)
			}
		}

		ASPRule rule = new ASPRule(body, weight, level, rightTerms);
		rule.setHead(head);
		return rule;
	}

	@Override
	public ASPHead visit(ASTHead node, Object data) {
		List<ASPLiteral> headAtoms = new ArrayList<ASPLiteral>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTAggregate) {
				AggregateAtom aggregate = visit((ASTAggregate) node.jjtGetChild(0), null);
				return new AggregateHead(aggregate);
			} else if (node.jjtGetChild(i) instanceof ASTChoice) {
				ChoiceHead choice = visit((ASTChoice) node.jjtGetChild(0), null);
				return choice;
			} else if (node.jjtGetChild(i) instanceof ASTHeadElementsList) {
				headAtoms = visit((ASTHeadElementsList) node.jjtGetChild(i), null);
			} else
				continue;
		}
		return new ClassicalHead(headAtoms);
	}

	@Override
	public List<ASPLiteral> visit(ASTHeadElementsList node, Object data) {
		List<ASPLiteral> elements = new ArrayList<ASPLiteral>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTLiteral) {
				ASPLiteral a = visit((ASTLiteral) node.jjtGetChild(i), null);
				elements.add(a);
			}
		}
		return elements;
	}

	@Override
	public List<ASPBodyElement> visit(ASTBodyList node, Object data) {
		List<ASPBodyElement> ruleBodies = new ArrayList<ASPBodyElement>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTBody) {
				List<ASPBodyElement> rule_body = visit((ASTBody) node.jjtGetChild(i), null);
				ruleBodies.addAll(rule_body);
			}
		}
		return ruleBodies;
	}

	@Override
	public List<ASPBodyElement> visit(ASTBody node, Object data) {
		List<ASPBodyElement> ruleBody = new ArrayList<ASPBodyElement>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTNAFLiteral) {
				ASPBodyElement l = visit((ASTNAFLiteral) node.jjtGetChild(i), null);
				ruleBody.add(l);
			} else if (node.jjtGetChild(i) instanceof ASTAggregate) {
				AggregateAtom l = visit((ASTAggregate) node.jjtGetChild(i), null);
				if (node.nafneg) {
					DefaultNegation nafl = new DefaultNegation(l);
					ruleBody.add(nafl);
				} else
					ruleBody.add(l);
			}
		}
		return ruleBody;
	}

	@Override
	public ChoiceHead visit(ASTChoice node, Object data) {
		List<ChoiceElement> choiceElements = new LinkedList<ChoiceElement>();
		ASPOperator.BinaryOperator rightOp = null;
		ASPOperator.BinaryOperator leftOp = null;
		Term<?> leftTerm = null;
		Term<?> rightTerm = null;

		int i = 0;
		// Add left guard
		if (node.jjtGetChild(0) instanceof ASTTerm) {
			leftTerm = visit((ASTTerm) node.jjtGetChild(i), null);
			try {
				leftOp = evaluateBinop(visit((ASTBinop) node.jjtGetChild(i + 1), null));
			} catch (ParseException e) {
				leftOp = null;
				e.printStackTrace();
			}
			i += 2;
		}

		// Add choice elements
		if (node.jjtGetChild(i) instanceof ASTChoiceElementList) {
			choiceElements = visit((ASTChoiceElementList) node.jjtGetChild(i), null);
			i++;
		}

		// Add right guard
		if ((node.jjtGetNumChildren() > i) && node.jjtGetChild(i + 1) instanceof ASTTerm) {
			try {
				rightOp = evaluateBinop(visit((ASTBinop) node.jjtGetChild(i), null));
			} catch (ParseException e) {
				rightOp = null;
				e.printStackTrace();
			}
			rightTerm = visit((ASTTerm) node.jjtGetChild(i + 1), null);
		}

		ChoiceHead head = new ChoiceHead(choiceElements);
		if (leftOp != null) {
			head.setLeftOperator(leftOp);
			head.setLeftGuard(leftTerm);
		}
		if (rightOp != null) {
			head.setRightOperator(rightOp);
			head.setRightGuard(rightTerm);
		}
		return head;
	}

	@Override
	public List<ChoiceElement> visit(ASTChoiceElementList node, Object data) {
		List<ChoiceElement> choiceElementList = new LinkedList<ChoiceElement>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTChoiceElement) {
				ChoiceElement a = visit((ASTChoiceElement) node.jjtGetChild(i), null);
				choiceElementList.add(a);
			}
		}
		return choiceElementList;
	}

	@Override
	public ChoiceElement visit(ASTChoiceElement node, Object data) {
		ASPLiteral a = visit((ASTLiteral) node.jjtGetChild(0), null);
		List<ASPBodyElement> nafliterals = new ArrayList<ASPBodyElement>();
		if (node.jjtGetNumChildren() > 1 && node.jjtGetChild(1) instanceof ASTNAFLiteralList) {
			nafliterals = visit((ASTNAFLiteralList) node.jjtGetChild(1), null);
		}
		return new ChoiceElement(a, nafliterals);
	}

	@Override
	public AggregateAtom visit(ASTAggregate node, Object data) {
		List<AggregateElement> aggElements = new LinkedList<AggregateElement>();
		ASPOperator.BinaryOperator rightOp = null;
		ASPOperator.BinaryOperator leftOp = null;
		Term<?> leftTerm = null;
		Term<?> rightTerm = null;

		int i = 0;
		// Add left guard
		if (node.jjtGetChild(0) instanceof ASTTerm) {
			leftTerm = visit((ASTTerm) node.jjtGetChild(i), null);
			try {
				leftOp = evaluateBinop(visit((ASTBinop) node.jjtGetChild(i + 1), null));
			} catch (ParseException e) {
				leftOp = null;
				e.printStackTrace();
			}
			i += 2;
		}

		ASPOperator.AggregateFunction result_func;
		try {
			result_func = evaluateAggrFunc(visit((ASTAggrFunc) node.jjtGetChild(i), null));
		} catch (ParseException e) {
			result_func = ASPOperator.AggregateFunction.COUNT;
			e.printStackTrace();
		}
		i++;

		// Add aggregate elements
		if (node.jjtGetChild(i) instanceof ASTAggrElementList) {
			aggElements = visit((ASTAggrElementList) node.jjtGetChild(i), null);
			i++;
		}

		// Add right guard
		if ((node.jjtGetNumChildren() > i) && node.jjtGetChild(i + 1) instanceof ASTTerm) {
			try {
				rightOp = evaluateBinop(visit((ASTBinop) node.jjtGetChild(i), null));
			} catch (ParseException e) {
				rightOp = null;
				e.printStackTrace();
			}
			rightTerm = visit((ASTTerm) node.jjtGetChild(i + 1), null);
		}

		return new AggregateAtom(result_func, aggElements, leftOp, leftTerm, rightOp, rightTerm);
	}

	/**
	 * Evaluates the given aggregate function string and returns the corresponding
	 * {@link ASPOperator.AggregateFunction}.
	 *
	 * @param func The string representation of the aggregate function.
	 * @return The {@link ASPOperator.AggregateFunction} corresponding to the
	 *         provided string.
	 * @throws ParseException If the provided string does not match any known
	 *                        aggregate function.
	 */
	public static ASPOperator.AggregateFunction evaluateAggrFunc(String func) throws ParseException {
		ASPOperator.AggregateFunction resultFunc = null;
		if (func.equals("#count"))
			resultFunc = ASPOperator.AggregateFunction.COUNT;
		else if (func.equals("#max"))
			resultFunc = ASPOperator.AggregateFunction.MAX;
		else if (func.equals("#min"))
			resultFunc = ASPOperator.AggregateFunction.MIN;
		else if (func.equals("#sum"))
			resultFunc = ASPOperator.AggregateFunction.SUM;
		else if (func.equals("#sum+"))
			resultFunc = ASPOperator.AggregateFunction.SUM_PLUS;
		else if (func.equals("#times"))
			resultFunc = ASPOperator.AggregateFunction.TIMES;
		else
			throw new ParseException("Parser returned unknown operator");
		return resultFunc;
	}

	@Override
	public List<AggregateElement> visit(ASTAggrElementList node, Object data) {
		List<AggregateElement> aggElementList = new LinkedList<AggregateElement>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTAggrElement) {
				AggregateElement a = visit((ASTAggrElement) node.jjtGetChild(i), null);
				aggElementList.add(a);
			}
		}
		return aggElementList;
	}

	@Override
	public AggregateElement visit(ASTAggrElement node, Object data) {
		List<Term<?>> l = new ArrayList<Term<?>>();
		List<ASPBodyElement> l2 = new ArrayList<ASPBodyElement>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTTermList)
				l = visit((ASTTermList) node.jjtGetChild(i), null);
			else if (node.jjtGetChild(i) instanceof ASTNAFLiteralList)
				l2 = visit((ASTNAFLiteralList) node.jjtGetChild(i), null);
		}
		return new AggregateElement(l, l2);
	}

	// Optimize statements are an alternative way of expressing
	// optimization problems. One optimize statement represents
	// a set of weak constraints.
	@Override
	public ASPRule visit(ASTOpt node, Object data) {
		List<OptimizationElement> optElements = new ArrayList<OptimizationElement>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTOptElementList) {
				optElements.addAll(visit((ASTOptElementList) node.jjtGetChild(i), null));
			}
		}
		OptimizationStatement opt;
		if (((ASTOptFunc) node.jjtGetChild(0)).maximize)
			opt = new OptimizationStatement(ASPOperator.OptimizeFunction.MAXIMIZE, optElements);
		else
			opt = new OptimizationStatement(ASPOperator.OptimizeFunction.MINIMIZE, optElements);
		return new ASPRule(opt);
	}

	@Override
	public List<OptimizationElement> visit(ASTOptElementList node, Object data) {
		List<OptimizationElement> optElements = new ArrayList<OptimizationElement>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTOptElement) {
				OptimizationElement r = visit((ASTOptElement) node.jjtGetChild(i), null);
				optElements.add(r);
			}
		}
		return optElements;
	}

	@Override
	public OptimizationElement visit(ASTOptElement node, Object data) {
		List<Term<?>> terms = visit((ASTWeight) node.jjtGetChild(0), null);
		Term<?> weight = terms.remove(0);
		Term<?> level = null;
		if (((ASTWeight) node.jjtGetChild(0)).hasLevel)
			level = terms.remove(0);

		List<ASPBodyElement> nafliterals = new ArrayList<ASPBodyElement>();

		for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTNAFLiteralList) {
				nafliterals = visit((ASTNAFLiteralList) node.jjtGetChild(i), null);
			}
		}

		OptimizationElement opt = new OptimizationElement(weight, terms, nafliterals);
		if (level != null)
			opt.setLevel(level);
		return opt;
	}

	@Override
	public List<Term<?>> visit(ASTWeight node, Object data) {
		List<Term<?>> terms = new ArrayList<Term<?>>();
		Term<?> t1 = visit((ASTTerm) node.jjtGetChild(0), null);
		terms.add(t1);
		if (node.jjtGetNumChildren() <= 1)
			return terms;

		for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTTerm) {
				Term<?> t2 = visit((ASTTerm) node.jjtGetChild(i), null);
				terms.add(t2);
			} else if (node.jjtGetChild(i) instanceof ASTTermList) {
				List<Term<?>> t3 = visit((ASTTermList) node.jjtGetChild(i), null);
				terms.addAll(t3);
				break;
			}
		}
		return terms;
	}

	@Override
	public List<ASPBodyElement> visit(ASTNAFLiteralList node, Object data) {
		List<ASPBodyElement> naflits = new LinkedList<ASPBodyElement>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTNAFLiteral) {
				ASPBodyElement n = visit((ASTNAFLiteral) node.jjtGetChild(i), null);
				naflits.add(n);
			}
		}
		return naflits;
	}

	@Override
	public ASPBodyElement visit(ASTNAFLiteral node, Object data) {
		ASPBodyElement at = null;
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTBuiltInAtom) {
				at = visit((ASTBuiltInAtom) node.jjtGetChild(i), null);
				if (node.nafneg)
					return new DefaultNegation(at);
			} else if (node.jjtGetChild(i) instanceof ASTLiteral) {
				at = visit((ASTLiteral) node.jjtGetChild(i), null);
				if (node.nafneg)
					return new DefaultNegation(at);
			}
		}
		return at;
	}

	@Override
	public ASPLiteral visit(ASTLiteral node, Object data) {
		String name = "";
		List<Term<?>> terms = new ArrayList<Term<?>>();

		boolean isDlvID = false;
		boolean isClingoID = false;
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTTermList)
				terms = visit((ASTTermList) node.jjtGetChild(i), null);
			if (node.jjtGetChild(i) instanceof ASTID)
				name = visit((ASTID) node.jjtGetChild(i), null);
			if (node.jjtGetChild(i) instanceof ASTDlvID) {
				name = visit((ASTDlvID) node.jjtGetChild(i), null);
				isDlvID = true;
			}
			if (node.jjtGetChild(i) instanceof ASTClingoID) {
				name = visit((ASTClingoID) node.jjtGetChild(i), null);
				isClingoID = true;
			}
		}

		ASPAtom at;
		if (isDlvID)
			at = new ASPAtom(new ASPOperator.DLVPredicate(name, terms.size()), terms);
		else if (isClingoID)
			at = new ASPAtom(new ASPOperator.ClingoPredicate(name, terms.size()), terms);
		else
			at = new ASPAtom(new Predicate(name, terms.size()), terms);
		if (node.neg)
			return new StrictNegation(at);
		return at;
	}

	@Override
	public ComparativeAtom visit(ASTBuiltInAtom node, Object data) {
		if (node.jjtGetChild(0) instanceof ASTDlvArithmeticID) {
			try {
				List<Term<?>> terms = visit((ASTTermList) node.jjtGetChild(1), null);
				String name = ((ASTDlvArithmeticID) node.jjtGetChild(0)).name;
				if (name.equals("#succ")) {
					if (terms.size() != 2)
						throw new ParseException(
								"Illegal number of arguments for #succ, expected 2 but got " + terms.size());
					// #succ(X, Y) is true, iff X+1=Y holds
					ArithmeticTerm leftTerm = new ArithmeticTerm(ASPOperator.ArithmeticOperator.PLUS, terms.get(0),
							new NumberTerm(1));
					return new ComparativeAtom(ASPOperator.BinaryOperator.EQ, leftTerm, terms.get(1));
				} else if (name.equals("#prec")) {
					if (terms.size() != 2)
						throw new ParseException(
								"Illegal number of arguments for #prec, expected 2 but got " + terms.size());
					// #prec(X, Y) is true, iff X-1=Y holds
					ArithmeticTerm leftTerm = new ArithmeticTerm(ASPOperator.ArithmeticOperator.MINUS, terms.get(0),
							new NumberTerm(1));
					return new ComparativeAtom(ASPOperator.BinaryOperator.EQ, leftTerm, terms.get(1));
				} else if (name.equals("#mod")) {
					if (terms.size() != 3)
						throw new ParseException(
								"Illegal number of arguments for #mod, expected 3 but got " + terms.size());
					// #mod(X, Y, Z) is true, iff X%Y=Z holds
					ArithmeticTerm leftTerm = new ArithmeticTerm(ASPOperator.ArithmeticOperator.MODULO, terms.get(0),
							terms.get(1));
					return new ComparativeAtom(ASPOperator.BinaryOperator.EQ, leftTerm, terms.get(2));
				} else
					throw new ParseException("Predicate is not supported by this parser:" + name);
			} catch (ParseException e) {
				e.printStackTrace();
				return null;
			}
		} else if (node.jjtGetChild(0) instanceof ASTArithop) {
			Term<?> term1 = visit((ASTTerm) node.jjtGetChild(1), null);
			Term<?> term2 = visit((ASTTerm) node.jjtGetChild(2), null);
			Term<?> term3 = visit((ASTTerm) node.jjtGetChild(3), null);
			ASPOperator.ArithmeticOperator op;
			try {
				op = evaluateArithop(((ASTArithop) node.jjtGetChild(0)).operator);
			} catch (ParseException e) {
				op = null;
				e.printStackTrace();
			}
			// +(X,Y,Z) is true iff Z=X+Y holds (analogously for -,*,/ operators)
			ArithmeticTerm leftTerm = new ArithmeticTerm(op, term1, term2);
			return new ComparativeAtom(ASPOperator.BinaryOperator.EQ, leftTerm, term3);
		} else {
			String op;
			Term<?> t1;
			Term<?> t2 = visit((ASTTerm) node.jjtGetChild(2), null);
			// case 1: op(term,term)
			if (node.jjtGetChild(0) instanceof ASTBinop) {
				op = visit((ASTBinop) node.jjtGetChild(0), null);
				t1 = visit((ASTTerm) node.jjtGetChild(1), null);
			}
			// case 2: term op term
			else {
				op = visit((ASTBinop) node.jjtGetChild(1), null);
				t1 = visit((ASTTerm) node.jjtGetChild(0), null);
			}
			ASPOperator.BinaryOperator resultOp;
			try {
				resultOp = evaluateBinop(op);
			} catch (ParseException e) {
				resultOp = ASPOperator.BinaryOperator.EQ;
				e.printStackTrace();
			}
			return new ComparativeAtom(resultOp, t1, t2);
		}
	}

	/**
	 * evaluateBinop
	 *
	 * @param op op string
	 * @return binary operator
	 * @throws ParseException error
	 */
	public static ASPOperator.BinaryOperator evaluateBinop(String op) throws ParseException {
		ASPOperator.BinaryOperator resultOp = ASPOperator.BinaryOperator.EQ;
		if (op.equals("=") || op.equals("=="))
			resultOp = ASPOperator.BinaryOperator.EQ;
		else if (op.equals("<>") || op.equals("!="))
			resultOp = ASPOperator.BinaryOperator.NEQ;
		else if (op.equals("<"))
			resultOp = ASPOperator.BinaryOperator.LT;
		else if (op.equals(">"))
			resultOp = ASPOperator.BinaryOperator.GT;
		else if (op.equals("<="))
			resultOp = ASPOperator.BinaryOperator.LEQ;
		else if (op.equals(">="))
			resultOp = ASPOperator.BinaryOperator.GEQ;
		else
			throw new ParseException("Parser returned unknown operator");
		return resultOp;
	}

	@Override
	public List<Term<?>> visit(ASTTermList node, Object data) {
		List<Term<?>> termList = new LinkedList<Term<?>>();
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTTerm) {
				Term<?> a = visit((ASTTerm) node.jjtGetChild(i), null);
				termList.add(a);
			}
		}
		return termList;
	}

	@Override
	public Term<?> visit(ASTTerm node, Object data) {
		Term<?> t = null;
		if (node.jjtGetChild(0) instanceof ASTID) {
			if (node.jjtGetChild(1) instanceof ASTTermList) {
				List<Term<?>> terms = visit((ASTTermList) node.jjtGetChild(1), null);
				Functor f = new Functor((((ASTID) node.jjtGetChild(0)).name));
				t = new FunctionalTerm(f, terms);
			} else
				t = new Constant(((ASTID) node.jjtGetChild(0)).name);
		} else if (node.jjtGetChild(0) instanceof ASTNumber)
			t = new NumberTerm((((ASTNumber) node.jjtGetChild(0)).number));
		else if (node.jjtGetChild(0) instanceof ASTVar)
			t = new Variable(((ASTVar) node.jjtGetChild(0)).name);
		else if (node.jjtGetChild(0) instanceof ASTString)
			t = new Constant((((ASTString) node.jjtGetChild(0)).name));
		else if (node.neg) {
			Term<?> t1 = visit((ASTTerm) node.jjtGetChild(0), null);
			t = new ArithmeticTerm(ASPOperator.ArithmeticOperator.MINUS, t1);
		} else
			t = visit((ASTTerm) node.jjtGetChild(0), null);

		if (node.jjtGetNumChildren() == 0)
			return t;

		for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTAriTerm) {
				Term<?> t2 = visit((ASTAriTerm) node.jjtGetChild(i), null);
				ASPOperator.ArithmeticOperator op;
				try {
					op = evaluateArithop(((ASTAriTerm) node.jjtGetChild(i)).op);
				} catch (ParseException e) {
					op = null;
					e.printStackTrace();
				}
				if (op != null)
					return new ArithmeticTerm(op, t, t2);
			}
		}
		return t;
	}

	/**
	 * Evaluates the given arithmetic operator string and returns the corresponding

	 *
	 * @param sop The string representation of the arithmetic operator.
	 * @return The operator corresponding to the
	 *         provided string, or {@code null} if the string is empty.
	 * @throws ParseException If the provided string does not match any known
	 *                        arithmetic operator.
	 */
	public static ASPOperator.ArithmeticOperator evaluateArithop(String sop) throws ParseException {
		if (sop.equals("+"))
			return ASPOperator.ArithmeticOperator.PLUS;
		else if (sop.equals("-"))
			return ASPOperator.ArithmeticOperator.MINUS;
		else if (sop.equals("/"))
			return ASPOperator.ArithmeticOperator.DIV;
		else if (sop.equals("*"))
			return ASPOperator.ArithmeticOperator.TIMES;
		else if (sop.equals("\\"))
			return ASPOperator.ArithmeticOperator.MODULO;
		else if (sop.equals(""))
			return null;
		else
			throw new ParseException("Parser returned unknown operator " + sop);
	}

	@Override
	public Term<?> visit(ASTAriTerm node, Object data) {
		for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
			if (node.jjtGetChild(i) instanceof ASTTerm)
				return visit((ASTTerm) node.jjtGetChild(i), null);
		}
		return null;
	}

	@Override
	public String visit(ASTBinop node, Object data) {
		return node.operator;
	}

	@Override
	public String visit(ASTArithop node, Object data) {
		return node.operator;
	}

	@Override
	public String visit(ASTAggrFunc node, Object data) {
		return node.func;
	}

	@Override
	public String visit(ASTOptFunc node, Object data) {
		return node.func;
	}

	@Override
	public Integer visit(ASTNumber node, Object data) {
		return node.number;
	}

	@Override
	public String visit(ASTVar node, Object data) {
		return node.name;
	}

	@Override
	public String visit(ASTID node, Object data) {
		return node.name;
	}

	@Override
	public String visit(ASTDlvID node, Object data) {
		return node.name;
	}

	@Override
	public Object visit(ASTDlvArithmeticID node, Object data) {
		return node.name;
	}

	@Override
	public String visit(ASTString node, Object data) {
		return node.name;
	}

	@Override
	public String visit(ASTClingoMeta node, Object data) {
		return node.statement;
	}

	@Override
	public String visit(ASTClingoID node, Object data) {
		return node.name;
	}

}
/*
 * JavaCC - OriginalChecksum=58043862b38d06e3c410ec37ecf72d1e (do not edit this
 * line)
 */
