/**
 *  This file is part of "TweetyProject", a collection of Java libraries for
 *  logical aspects of artificial intelligence and knowledge representation.
 *
 *  TweetyProject is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  Copyright 2016 The TweetyProject Team <http://tweetyproject.org/contact/>
 */
/* Generated By:JavaCC: Do not edit this line. SimpleCharStream.java Version 5.0 */
/* JavaCCOptions:STATIC=true,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package org.tweetyproject.logics.rpcl.parser.rpclcondensedprobabilitydistributionparser;

/**
 * An implementation of interface CharStream, where the stream is assumed to
 * contain only ASCII characters (without unicode processing).
 */
public class SimpleCharStream {
  /** Whether parser is static. */
  public static final boolean staticFlag = true;
  /** bufsize */
  static int bufsize;
  /** available */
  static int available;
  /** tokenBegin */
  static int tokenBegin;
  /** Position in buffer. */
  static public int bufpos = -1;
  /** bufline */
  static protected int bufline[];
  /** bufcolumn */
  static protected int bufcolumn[];

  /** Position in buffer. */
  static protected int column = 0;
  /** Position in buffer. */
  static protected int line = 1;

  /** prevCharIsCR. */
  static protected boolean prevCharIsCR = false;
  /** prevCharIsLF */
  static protected boolean prevCharIsLF = false;

  /** inputStream. */
  static protected java.io.Reader inputStream;

  /** Position in buffer. */
  static protected char[] buffer;
  /** maxNextCharInd. */
  static protected int maxNextCharInd = 0;
  /** in buffer. */
  static protected int inBuf = 0;
  /** tabsize. */
  static protected int tabSize = 8;

  /**
   * setter
   * @param i index
   */
  static protected void setTabSize(int i) {
    tabSize = i;
  }

  /**
   * Getter
   * @param i index
   * @return tabb size
   */
  static protected int getTabSize(int i) {
    return tabSize;
  }

  /**
   * ExpandBuffer
   * @param wrapAround is warpAround
   */
  static protected void ExpandBuff(boolean wrapAround) {
    char[] newbuffer = new char[bufsize + 2048];
    int newbufline[] = new int[bufsize + 2048];
    int newbufcolumn[] = new int[bufsize + 2048];

    try {
      if (wrapAround) {
        System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
        System.arraycopy(buffer, 0, newbuffer, bufsize - tokenBegin, bufpos);
        buffer = newbuffer;

        System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
        System.arraycopy(bufline, 0, newbufline, bufsize - tokenBegin, bufpos);
        bufline = newbufline;

        System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
        System.arraycopy(bufcolumn, 0, newbufcolumn, bufsize - tokenBegin, bufpos);
        bufcolumn = newbufcolumn;

        maxNextCharInd = (bufpos += (bufsize - tokenBegin));
      } else {
        System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
        buffer = newbuffer;

        System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
        bufline = newbufline;

        System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
        bufcolumn = newbufcolumn;

        maxNextCharInd = (bufpos -= tokenBegin);
      }
    } catch (Throwable t) {
      throw new Error(t.getMessage());
    }

    bufsize += 2048;
    available = bufsize;
    tokenBegin = 0;
  }

  /**
   * FillBuffer
   * @throws java.io.IOException error
   */
  static protected void FillBuff() throws java.io.IOException {
    if (maxNextCharInd == available) {
      if (available == bufsize) {
        if (tokenBegin > 2048) {
          bufpos = maxNextCharInd = 0;
          available = tokenBegin;
        } else if (tokenBegin < 0)
          bufpos = maxNextCharInd = 0;
        else
          ExpandBuff(false);
      } else if (available > tokenBegin)
        available = bufsize;
      else if ((tokenBegin - available) < 2048)
        ExpandBuff(true);
      else
        available = tokenBegin;
    }

    int i;
    try {
      if ((i = inputStream.read(buffer, maxNextCharInd, available - maxNextCharInd)) == -1) {
        inputStream.close();
        throw new java.io.IOException();
      } else
        maxNextCharInd += i;
      return;
    } catch (java.io.IOException e) {
      --bufpos;
      backup(0);
      if (tokenBegin == -1)
        tokenBegin = bufpos;
      throw e;
    }
  }

  /** Start.
   * @return chars
   * @throws java.io.IOException error
  */
  static public char BeginToken() throws java.io.IOException {
    tokenBegin = -1;
    char c = readChar();
    tokenBegin = bufpos;

    return c;
  }
  /**
   * Update
   * @param c the character
   */
  static protected void UpdateLineColumn(char c) {
    column++;

    if (prevCharIsLF) {
      prevCharIsLF = false;
      line += (column = 1);
    } else if (prevCharIsCR) {
      prevCharIsCR = false;
      if (c == '\n') {
        prevCharIsLF = true;
      } else
        line += (column = 1);
    }

    switch (c) {
      case '\r':
        prevCharIsCR = true;
        break;
      case '\n':
        prevCharIsLF = true;
        break;
      case '\t':
        column--;
        column += (tabSize - (column % tabSize));
        break;
      default:
        break;
    }

    bufline[bufpos] = line;
    bufcolumn[bufpos] = column;
  }

  /** Read a character.
   * @return chars
   * @throws java.io.IOException error
  */
  static public char readChar() throws java.io.IOException {
    if (inBuf > 0) {
      --inBuf;

      if (++bufpos == bufsize)
        bufpos = 0;

      return buffer[bufpos];
    }

    if (++bufpos >= maxNextCharInd)
      FillBuff();

    char c = buffer[bufpos];

    UpdateLineColumn(c);
    return c;
  }

  /**
   * @deprecated
   * @see #getEndColumn
   *  Getter
   * @return the column
   */
  @Deprecated
  static public int getColumn() {
    return bufcolumn[bufpos];
  }

  /**
   * @deprecated
   * @see #getEndLine
   * Getter line
   * @return the line
   */
  @Deprecated
  static public int getLine() {
    return bufline[bufpos];
  }

  /** Get token end column number.
   * @return token end
  */
  static public int getEndColumn() {
    return bufcolumn[bufpos];
  }

  /** Get token end line number.
   * @return token
  */
  static public int getEndLine() {
    return bufline[bufpos];
  }

  /** Get token beginning column number.
   * @return token beginning
  */
  static public int getBeginColumn() {
    return bufcolumn[tokenBegin];
  }

  /** Get token beginning line number.
   * @return token
  */
  static public int getBeginLine() {
    return bufline[tokenBegin];
  }

  /** Backup a number of characters.
   * @param amount the amount
  */
  static public void backup(int amount) {

    inBuf += amount;
    if ((bufpos -= amount) < 0)
      bufpos += bufsize;
  }

  /**
   * Constructs a new {@code SimpleCharStream} instance with the specified input
   * stream, start line, start column,
   * and buffer size.
   *
   * <p>
   * This constructor initializes the character stream with the provided
   * {@code Reader} and sets up the internal
   * buffer and tracking information based on the given parameters. If the
   * {@code inputStream} is already initialized,
   * it throws an {@code Error} indicating that the constructor should not be
   * called again. This behavior is intended
   * to prevent multiple initializations of a static instance of
   * {@code SimpleCharStream}.
   * </p>
   *
   * @param dstream     The {@code Reader} from which characters will be read.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   * @param buffersize  The size of the buffer to use for reading characters.
   *
   * @throws Error If this constructor is called more than once, indicating a
   *               misuse of the static instance.
   */
  public SimpleCharStream(java.io.Reader dstream, int startline, int startcolumn, int buffersize) {
    if (inputStream != null)
      throw new Error("\n   ERROR: Second call to the constructor of a static SimpleCharStream.\n" +
          "       You must either use ReInit() or set the JavaCC option STATIC to false\n" +
          "       during the generation of this class.");
    inputStream = dstream;
    line = startline;
    column = startcolumn - 1;

    available = bufsize = buffersize;
    buffer = new char[buffersize];
    bufline = new int[buffersize];
    bufcolumn = new int[buffersize];
  }

  /**
   * Constructs a new {@code SimpleCharStream} instance with the specified input
   * stream, start line, and start column,
   * using a default buffer size of 4096.
   *
   * @param dstream     The {@code Reader} from which characters will be read.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   */
  public SimpleCharStream(java.io.Reader dstream, int startline, int startcolumn) {
    this(dstream, startline, startcolumn, 4096);
  }

  /**
   * Constructs a new {@code SimpleCharStream} instance with the specified input
   * stream, using default values for
   * the start line, start column, and buffer size.
   *
   * @param dstream The {@code Reader} from which characters will be read.
   */
  public SimpleCharStream(java.io.Reader dstream) {
    this(dstream, 1, 1, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} instance with a new
   * {@code Reader}, starting line, starting column,
   * and buffer size. This method clears the existing buffer and sets up a new
   * buffer if necessary.
   *
   * <p>
   * This method updates the internal state of the character stream to reflect the
   * new input stream and reinitializes
   * the buffer and tracking variables. If the buffer size changes, a new buffer
   * is allocated. This method should be
   * used when you need to reuse the same {@code SimpleCharStream} instance with
   * different input or buffer settings.
   * </p>
   *
   * @param dstream     The new {@code Reader} from which characters will be read.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   * @param buffersize  The size of the buffer to use for reading characters.
   */
  public void ReInit(java.io.Reader dstream, int startline, int startcolumn, int buffersize) {
    inputStream = dstream;
    line = startline;
    column = startcolumn - 1;

    if (buffer == null || buffersize != buffer.length) {
      available = bufsize = buffersize;
      buffer = new char[buffersize];
      bufline = new int[buffersize];
      bufcolumn = new int[buffersize];
    }
    prevCharIsLF = prevCharIsCR = false;
    tokenBegin = inBuf = maxNextCharInd = 0;
    bufpos = -1;
  }

  /**
   * Reinitializes the {@code SimpleCharStream} instance with a new
   * {@code Reader}, starting line, and starting column,
   * using a default buffer size of 4096.
   *
   * @param dstream     The new {@code Reader} from which characters will be read.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   */
  public void ReInit(java.io.Reader dstream, int startline, int startcolumn) {
    ReInit(dstream, startline, startcolumn, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} instance with a new
   * {@code Reader}, using default values for
   * the starting line, starting column, and buffer size.
   *
   * @param dstream The new {@code Reader} from which characters will be read.
   */
  public void ReInit(java.io.Reader dstream) {
    ReInit(dstream, 1, 1, 4096);
  }

  /**
   * Constructs a new {@code SimpleCharStream} instance with the specified input
   * stream, character encoding,
   * starting line, starting column, and buffer size.
   *
   * @param dstream     The {@code InputStream} from which characters will be
   *                    read.
   * @param encoding    The character encoding to use. If {@code null}, the
   *                    default encoding will be used.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   * @param buffersize  The size of the buffer to use for reading characters.
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public SimpleCharStream(java.io.InputStream dstream, String encoding, int startline, int startcolumn, int buffersize)
      throws java.io.UnsupportedEncodingException {
    this(encoding == null ? new java.io.InputStreamReader(dstream) : new java.io.InputStreamReader(dstream, encoding),
        startline, startcolumn, buffersize);
  }

  /**
   * Constructs a new {@code SimpleCharStream} instance with the specified input
   * stream, starting line, starting column,
   * and buffer size, using the default character encoding.
   *
   * @param dstream     The {@code InputStream} from which characters will be
   *                    read.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   * @param buffersize  The size of the buffer to use for reading characters.
   */
  public SimpleCharStream(java.io.InputStream dstream, int startline, int startcolumn, int buffersize) {
    this(new java.io.InputStreamReader(dstream), startline, startcolumn, buffersize);
  }

  /**
   * Constructs a new {@code SimpleCharStream} instance with the specified input
   * stream, character encoding,
   * starting line, and starting column, using a default buffer size of 4096.
   *
   * @param dstream     The {@code InputStream} from which characters will be
   *                    read.
   * @param encoding    The character encoding to use. If {@code null}, the
   *                    default encoding will be used.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public SimpleCharStream(java.io.InputStream dstream, String encoding, int startline, int startcolumn)
      throws java.io.UnsupportedEncodingException {
    this(dstream, encoding, startline, startcolumn, 4096);
  }

  /**
   * Constructs a new {@code SimpleCharStream} instance with the specified input
   * stream, starting line,
   * and starting column, using a default buffer size of 4096 and the default
   * character encoding.
   *
   * @param dstream     The {@code InputStream} from which characters will be
   *                    read.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   */
  public SimpleCharStream(java.io.InputStream dstream, int startline, int startcolumn) {
    this(dstream, startline, startcolumn, 4096);
  }

  /**
   * Constructs a new {@code SimpleCharStream} instance with the specified input
   * stream and character encoding,
   * using default values for the starting line, starting column, and buffer size.
   *
   * @param dstream  The {@code InputStream} from which characters will be read.
   * @param encoding The character encoding to use. If {@code null}, the default
   *                 encoding will be used.
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public SimpleCharStream(java.io.InputStream dstream, String encoding) throws java.io.UnsupportedEncodingException {
    this(dstream, encoding, 1, 1, 4096);
  }

  /**
   * Constructs a new {@code SimpleCharStream} instance with the specified input
   * stream, using default values
   * for the starting line, starting column, buffer size, and character encoding.
   *
   * @param dstream The {@code InputStream} from which characters will be read.
   */
  public SimpleCharStream(java.io.InputStream dstream) {
    this(dstream, 1, 1, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified input stream,
   * character encoding,
   * starting line, starting column, and buffer size.
   *
   * @param dstream     The {@code InputStream} from which characters will be
   *                    read.
   * @param encoding    The character encoding to use. If {@code null}, the
   *                    default encoding will be used.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   * @param buffersize  The size of the buffer to use for reading characters.
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public void ReInit(java.io.InputStream dstream, String encoding, int startline,
      int startcolumn, int buffersize) throws java.io.UnsupportedEncodingException {
    ReInit(encoding == null ? new java.io.InputStreamReader(dstream) : new java.io.InputStreamReader(dstream, encoding),
        startline, startcolumn, buffersize);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified input stream,
   * starting line,
   * starting column, and buffer size, using the default character encoding.
   *
   * @param dstream     The {@code InputStream} from which characters will be
   *                    read.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   * @param buffersize  The size of the buffer to use for reading characters.
   */
  public void ReInit(java.io.InputStream dstream, int startline,
      int startcolumn, int buffersize) {
    ReInit(new java.io.InputStreamReader(dstream), startline, startcolumn, buffersize);
  }

  /**
   * Reinitializes the {@code SimpleCharStream}
   *
   * @param dstream  The {@code InputStream} from which characters will be read.
   * @param encoding The character encoding to use. If {@code null}, the default
   *                 encoding will be used.
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public void ReInit(java.io.InputStream dstream, String encoding) throws java.io.UnsupportedEncodingException {
    ReInit(dstream, encoding, 1, 1, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified input stream,
   * using default values
   * for the starting line (1), starting column (1), buffer size (4096), and
   * character encoding.
   *
   * @param dstream The {@code InputStream} from which characters will be read.
   */
  public void ReInit(java.io.InputStream dstream) {
    ReInit(dstream, 1, 1, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified input stream,
   * character encoding,
   * starting line, and starting column, using a default buffer size of 4096.
   *
   * @param dstream     The {@code InputStream} from which characters will be
   *                    read.
   * @param encoding    The character encoding to use. If {@code null}, the
   *                    default encoding will be used.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public void ReInit(java.io.InputStream dstream, String encoding, int startline,
      int startcolumn) throws java.io.UnsupportedEncodingException {
    ReInit(dstream, encoding, startline, startcolumn, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified input stream,
   * starting line,
   * and starting column, using default values for the buffer size (4096) and
   * character encoding.
   *
   * @param dstream     The {@code InputStream} from which characters will be
   *                    read.
   * @param startline   The line number where reading starts (1-based index).
   * @param startcolumn The column number where reading starts (1-based index).
   */
  public void ReInit(java.io.InputStream dstream, int startline,
      int startcolumn) {
    ReInit(dstream, startline, startcolumn, 4096);
  }

  /** Get token literal value.
   * @return image
  */
  static public String GetImage() {
    if (bufpos >= tokenBegin)
      return new String(buffer, tokenBegin, bufpos - tokenBegin + 1);
    else
      return new String(buffer, tokenBegin, bufsize - tokenBegin) +
          new String(buffer, 0, bufpos + 1);
  }

  /** Get the suffix.
   * @param len length
   * @return  the suffix
  */
  static public char[] GetSuffix(int len) {
    char[] ret = new char[len];

    if ((bufpos + 1) >= len)
      System.arraycopy(buffer, bufpos - len + 1, ret, 0, len);
    else {
      System.arraycopy(buffer, bufsize - (len - bufpos - 1), ret, 0,
          len - bufpos - 1);
      System.arraycopy(buffer, 0, ret, len - bufpos - 1, bufpos + 1);
    }

    return ret;
  }

  /** Reset buffer when finished. */
  static public void Done() {
    buffer = null;
    bufline = null;
    bufcolumn = null;
  }

  /**
   * Method to adjust line and column numbers for the start of a token.
   * @param newLine new line
   * @param newCol new column
   */
  static public void adjustBeginLineColumn(int newLine, int newCol) {
    int start = tokenBegin;
    int len;

    if (bufpos >= tokenBegin) {
      len = bufpos - tokenBegin + inBuf + 1;
    } else {
      len = bufsize - tokenBegin + bufpos + 1 + inBuf;
    }

    int i = 0, j = 0, k = 0;
    int nextColDiff = 0, columnDiff = 0;

    while (i < len && bufline[j = start % bufsize] == bufline[k = ++start % bufsize]) {
      bufline[j] = newLine;
      nextColDiff = columnDiff + bufcolumn[k] - bufcolumn[j];
      bufcolumn[j] = newCol + columnDiff;
      columnDiff = nextColDiff;
      i++;
    }

    if (i < len) {
      bufline[j] = newLine++;
      bufcolumn[j] = newCol + columnDiff;

      while (i++ < len) {
        if (bufline[j = start % bufsize] != bufline[++start % bufsize])
          bufline[j] = newLine++;
        else
          bufline[j] = newLine;
      }
    }

    line = bufline[j];
    column = bufcolumn[j];
  }

}
/*
 * JavaCC - OriginalChecksum=81b95ca0cd70a80b7890fec9912ddbf5 (do not edit this
 * line)
 */
