/**
 *  This file is part of "TweetyProject", a collection of Java libraries for
 *  logical aspects of artificial intelligence and knowledge representation.
 *
 *  TweetyProject is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  Copyright 2016 The TweetyProject Team <http://tweetyproject.org/contact/>
 */
/** Generated By:JavaCC: Do not edit this line. RpclProbabilityDistributionParser.java */
package org.tweetyproject.logics.rpcl.parser.rpclprobabilitydistributionparser;

import java.io.*;
import java.util.*;

import org.tweetyproject.commons.*;
import org.tweetyproject.commons.util.*;
import org.tweetyproject.logics.commons.syntax.Constant;
import org.tweetyproject.logics.commons.syntax.Predicate;
import org.tweetyproject.logics.fol.semantics.*;
import org.tweetyproject.logics.fol.syntax.*;
import org.tweetyproject.logics.rpcl.semantics.*;
import org.tweetyproject.math.probability.*;

/**
 * This class implements a parser for relational probability distributions. The
 * BNF for
 * relational probability distributions is given by (start symbol is
 * DISTRIBUTION)
 * <br>
 * <br>
 * DISTRIBUTION ::== (PROBABILITYASSIGNMENT)*
 * <br>
 * PROBABILITYASSIGNMENT ::== INTERPRETATION "=" PROBABILITY
 * <br>
 * INTERPRETATION ::== "{" (GROUNDATOM ("," GROUNDATOM)*)? "}"
 * <br>
 * GROUNDATOM ::== PREDICATE ("(" CONSTANT ("," CONSTANT)* ")")?
 * <br>
 * <br>
 * PREDICATE is a sequence of symbols from {a,...,z,A,...,Z,0,...,9} with a
 * lowercase letter at the beginning.<br>
 * <br>
 * CONSTANT is a sequence of symbols from {a,...,z,A,...,Z,0,...,9} with a
 * lowercase letter at the beginning.<br>
 * <br>
 * PROBABILITY is a number in [0,1].<br>
 */

/**
 * Parser for reading and parsing RPCL (Relational Probabilistic Conditional
 * Logic) probability distributions.
 * <p>
 * This parser can read from various inputs and convert them into a
 * {@link RpclProbabilityDistribution}.
 * The parser uses semantics from {@link RpclSemantics} and a signature from
 * {@link FolSignature}.
 * </p>
 */
@SuppressWarnings("all")
public class RpclProbabilityDistributionParser implements RpclProbabilityDistributionParserConstants {

  /**
   * The semantics used for the distribution to be read.
   */
  private RpclSemantics semantics = null;

  /**
   * The signature for this parser (if one has been given)
   */
  private FolSignature signature = null;

  /** Default constructor. */
  public RpclProbabilityDistributionParser() {
  }

  /**
   * Constructor that initializes the parser with the given semantics.
   *
   * @param semantics The {@link RpclSemantics} to use for parsing.
   */
  public RpclProbabilityDistributionParser(RpclSemantics semantics) {
    this(semantics, null);
  }

  /**
   * Constructor that initializes the parser with the given semantics and
   * signature.
   *
   * @param semantics The {@link RpclSemantics} to use for parsing.
   * @param signature The {@link FolSignature} to use for interpreting terms.
   */
  public RpclProbabilityDistributionParser(RpclSemantics semantics, FolSignature signature) {
    this.semantics = semantics;
    this.signature = signature;
  }

  /**
   * Sets the semantics to be used for parsing the probability distribution.
   *
   * @param semantics The {@link RpclSemantics} to set.
   */
  public void setSemantics(RpclSemantics semantics) {
    this.semantics = semantics;
  }

  /**
   * Sets the signature to be used for interpreting the parsed terms.
   *
   * @param signature The {@link FolSignature} to set.
   */
  public void setSignature(FolSignature signature) {
    this.signature = signature;
  }

  /**
   * Parses the probability distribution from the provided reader.
   * <p>
   * This method reads from the {@link Reader} and parses the input into an
   * {@link RpclProbabilityDistribution}.
   * It uses the currently set semantics and signature to interpret the data.
   * </p>
   *
   * @param reader The {@link Reader} to read the input from.
   * @return The parsed {@link RpclProbabilityDistribution}.
   * @throws ParserException If a parsing error occurs.
   */
  public RpclProbabilityDistribution parseProbabilityDistribution(Reader reader) throws ParserException {
    try {
      RpclProbabilityDistributionParser theParser = new RpclProbabilityDistributionParser(reader);
      return theParser.Distribution(this.semantics, this.signature);
    } catch (ParseException e) {
      throw new ParserException(e);
    }
  }

  /**
   * Constructor
   * @param semantics the semantic
   * @param signature the signature
   * @return a RpclProbabilityDistribution
   * @throws ParseException error
   */
  static final public RpclProbabilityDistribution Distribution(RpclSemantics semantics, FolSignature signature)
      throws ParseException {
    Set<Pair<HerbrandInterpretation, Probability>> assignments = new HashSet<Pair<HerbrandInterpretation, Probability>>();
    Pair<HerbrandInterpretation, Probability> assignment;
    if (signature == null)
      signature = new FolSignature();
    label_1: while (true) {
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case 7:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
      }
      assignment = ProbabilityAssignment(signature);
      assignments.add(assignment);
    }
    jj_consume_token(0);
    RpclProbabilityDistribution distribution = new RpclProbabilityDistribution(semantics, signature);
    for (Pair<HerbrandInterpretation, Probability> a : assignments)
      distribution.put(a.getFirst(), a.getSecond());
    {
      if (true)
        return distribution;
    }
    throw new Error("Missing return statement in function");
  }

  /**
   * Parses and returns a pair consisting of a {@link HerbrandInterpretation} and
   * its associated {@link Probability}.
   * <p>
   * This method parses a set of ground atoms and their associated probability
   * from the input stream.
   * The ground atoms are parsed and added to a {@link HerbrandInterpretation}.
   * The associated probability is then parsed
   * and the pair is returned.
   * </p>
   *
   * @param signature the {@link FolSignature} to which the constants and
   *                  predicates belong.
   *                  If a constant or predicate is not found in the signature, it
   *                  is added to it.
   * @return a {@link Pair} consisting of a {@link HerbrandInterpretation}
   *         containing the parsed ground atoms,
   *         and a {@link Probability} representing the parsed probability.
   * @throws ParseException if there is an error during parsing, such as
   *                        unexpected tokens in the input stream.
   */
  static final public Pair<HerbrandInterpretation, Probability> ProbabilityAssignment(FolSignature signature)
      throws ParseException {
    Set<FolAtom> atoms = new HashSet<FolAtom>();
    FolAtom atom;
    Token probability;
    jj_consume_token(7);
    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case STRUCTURENAME:
        atom = GroundAtom(signature);
        atoms.add(atom);
        label_2: while (true) {
          switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 8:
              ;
              break;
            default:
              jj_la1[1] = jj_gen;
              break label_2;
          }
          jj_consume_token(8);
          atom = GroundAtom(signature);
          atoms.add(atom);
        }
        break;
      default:
        jj_la1[2] = jj_gen;
        ;
    }
    jj_consume_token(9);
    jj_consume_token(10);
    probability = jj_consume_token(PROBABILITY);
    {
      if (true)
        return new Pair<HerbrandInterpretation, Probability>(new HerbrandInterpretation(atoms),
            new Probability(new Double(token.image)));
    }
    throw new Error("Missing return statement in function");
  }

  /**
   * Parses and returns a ground atom (an atom where all terms are constants) from
   * the input stream.
   * <p>
   * A ground atom consists of a predicate symbol and zero or more constant
   * arguments.
   * This method reads the predicate and its corresponding constants (if any),
   * checks if they already exist in the given {@link FolSignature}, and adds them
   * if they do not.
   * </p>
   *
   * @param signature the {@link FolSignature} to which the constants and
   *                  predicate belong.
   *                  If a constant or predicate is not found in the signature, it
   *                  is added to it.
   * @return a {@link FolAtom} representing the parsed ground atom.
   * @throws ParseException if there is an error during parsing, such as
   *                        unexpected tokens in the input stream.
   */
  static final public FolAtom GroundAtom(FolSignature signature) throws ParseException {
    Token predicate;
    Token constant;
    List<Constant> parameters = new ArrayList<Constant>();
    Constant c = null;
    predicate = jj_consume_token(STRUCTURENAME);
    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case 11:
        jj_consume_token(11);
        constant = jj_consume_token(STRUCTURENAME);
        if (signature.containsConstant(constant.image)) {
          c = signature.getConstant(constant.image);
          parameters.add(c);
        } else {
          c = new Constant(constant.image);
          signature.add(c);
          parameters.add(c);
        }
        label_3: while (true) {
          switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 8:
              ;
              break;
            default:
              jj_la1[3] = jj_gen;
              break label_3;
          }
          jj_consume_token(8);
          constant = jj_consume_token(STRUCTURENAME);
          if (signature.containsConstant(constant.image)) {
            c = signature.getConstant(constant.image);
            parameters.add(c);
          } else {
            c = new Constant(constant.image);
            signature.add(c);
            parameters.add(c);
          }
        }
        jj_consume_token(12);
        break;
      default:
        jj_la1[4] = jj_gen;
        ;
    }
    Predicate p;
    if (signature.containsPredicate(predicate.image))
      p = signature.getPredicate(predicate.image);
    else {
      p = new Predicate(predicate.image, parameters.size());
      signature.add(p);
    }
    {
      if (true)
        return new FolAtom(p, parameters);
    }
    throw new Error("Missing return statement in function");
  }

  /** jj_initialized_once */
  static private boolean jj_initialized_once = false;
  /** Generated Token Manager. */
  static public RpclProbabilityDistributionParserTokenManager token_source;
  /** input stream */
  static SimpleCharStream jj_input_stream;
  /** Current token. */
  static public Token token;
  /** Next token. */
  static public Token jj_nt;
  /** Next token. */
  static private int jj_ntk;
  /** Next token. */
  static private int jj_gen;
  /** Next token. */
  static final private int[] jj_la1 = new int[5];
  /** Next token. */
  static private int[] jj_la1_0;
  static {
    jj_la1_init_0();
  }

  private static void jj_la1_init_0() {
    jj_la1_0 = new int[] { 0x80, 0x100, 0x20, 0x100, 0x800, };
  }

  /**
   * Constructor for parsing with {@link InputStream}.
   *
   * @param stream The input stream to be parsed.
   */
  public RpclProbabilityDistributionParser(java.io.InputStream stream) {
    this(stream, null);
  }

  /**
   * Constructor for parsing with {@link InputStream} and specified encoding.
   *
   * @param stream   The input stream to be parsed.
   * @param encoding The character encoding to be used, or <code>null</code> for
   *                 the platform's default encoding.
   * @throws RuntimeException If an unsupported encoding is provided.
   * @throws Error            If the constructor is called more than once when the
   *                          parser is set to be static.
   */
  public RpclProbabilityDistributionParser(java.io.InputStream stream, String encoding) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  ");
      System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    try {
      jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
    } catch (java.io.UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
    token_source = new RpclProbabilityDistributionParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++)
      jj_la1[i] = -1;
  }

  /**
 * Reinitialises the parser with a new input stream.
 * This method resets the input stream to the new one provided, along with all associated
 * parser states such as tokens and lookahead variables.
 *
 * @param stream the new input stream to be parsed.
 */
  static public void ReInit(java.io.InputStream stream) {
    ReInit(stream, null);
  }

  /**
 * Reinitialises the parser with a new input stream and specified encoding.
 * This method resets the input stream to the new one provided and reinitializes
 * the parser with the specified character encoding.
 * <p>
 * If the encoding is not supported, a {@link RuntimeException} is thrown.
 * This method also resets tokens, lookahead variables, and the token source.
 *
 * @param stream   the new input stream to be parsed.
 * @param encoding the character encoding used for reading the input stream, or {@code null}
 *                 for the platform default encoding.
 * @throws RuntimeException if the specified encoding is not supported.
 */
  static public void ReInit(java.io.InputStream stream, String encoding) {
    try {
      jj_input_stream.ReInit(stream, encoding, 1, 1);
    } catch (java.io.UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++)
      jj_la1[i] = -1;
  }

  /**
   * Constructor for parsing with a {@link Reader}.
   * This constructor initializes the parser using a character-based input reader.
   * <p>
   * The parser should only be initialized once if it is static. If this
   * constructor
   * is called more than once when the parser is static, it throws an error. For
   * subsequent uses, the parser should be reinitialized using the
   * {@code ReInit()} method.
   * </p>
   *
   * @param stream The {@link Reader} providing the input to be parsed.
   * @throws Error If the constructor is called more than once when the parser is
   *               static.
   */
  public RpclProbabilityDistributionParser(java.io.Reader stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser. ");
      System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new RpclProbabilityDistributionParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++)
      jj_la1[i] = -1;
  }

  /**
 * Reinitialises the parser with a new {@link Reader} input stream.
 * This method resets the input stream to the new one provided, along with all associated
 * parser states such as tokens, lookahead variables, and the token source.
 * <p>
 * The method assumes the input starts at the first line and first column.
 *
 * @param stream the new {@link Reader} input stream to be parsed.
 */
  static public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++)
      jj_la1[i] = -1;
  }

  /**
   * Constructor for the parser with a generated Token Manager.
   * <p>
   * This constructor initializes the `RpclProbabilityDistributionParser` with a
   * custom
   * {@link RpclProbabilityDistributionParserTokenManager}. The token manager is
   * responsible
   * for generating tokens from the input source.
   * </p>
   * <p>
   * This constructor should only be called once if the parser is static. If this
   * constructor
   * is called more than once when the parser is static, it throws an error. To
   * reinitialize the parser,
   * the {@code ReInit()} method should be used instead.
   * </p>
   *
   * @param tm The {@link RpclProbabilityDistributionParserTokenManager}
   *           responsible for token generation.
   * @throws Error If the constructor is called more than once when the parser is
   *               static.
   */
  public RpclProbabilityDistributionParser(RpclProbabilityDistributionParserTokenManager tm) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser. ");
      System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++)
      jj_la1[i] = -1;
  }

  /**
 * Reinitialises the parser with a new {@link RpclProbabilityDistributionParserTokenManager}.
 * This method resets the parser's internal state and prepares it to process new tokens
 * provided by the given token manager.
 * <p>
 * The token manager is responsible for providing tokens to the parser during parsing.
 * The method also resets all lookahead variables, ensuring that the parser starts fresh with
 * no leftover state from previous parsing.
 *
 * @param tm the new {@link RpclProbabilityDistributionParserTokenManager} that provides tokens
 *           for parsing.
 */
  public void ReInit(RpclProbabilityDistributionParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++)
      jj_la1[i] = -1;
  }

  static private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null)
      token = token.next;
    else
      token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  /**
   * Retrieve the next token from the token stream.
   * <p>
   * This method moves the parser to the next token in the input stream. If the
   * next token
   * has already been generated and is available, it is returned immediately.
   * Otherwise,
   * the next token is fetched from the token source.
   * </p>
   *
   * @return the next {@link Token} in the input stream.
   */
  static final public Token getNextToken() {
    if (token.next != null)
      token = token.next;
    else
      token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  /**
   * Retrieve the next token from the token stream.
   * <p>
   * This method moves the parser to the next token in the input stream. If the
   * next token
   * has already been generated and is available, it is returned immediately.
   * Otherwise,
   * the next token is fetched from the token source.
   * </p>
   * @param index the index
   * @return the next {@link Token} in the input stream.
   */
  static final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null)
        t = t.next;
      else
        t = t.next = token_source.getNextToken();
    }
    return t;
  }

  static private int jj_ntk() {
    if ((jj_nt = token.next) == null)
      return (jj_ntk = (token.next = token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  static private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  static private int[] jj_expentry;
  static private int jj_kind = -1;

  /**
   * Generate a {@link ParseException} when an error occurs during parsing.
   * <p>
   * This method collects information about the tokens that were expected but not
   * found
   * during parsing, and generates a {@link ParseException} containing details
   * about the
   * error. It is used to report errors and provide feedback about what was
   * expected at
   * the point of failure in the parsing process.
   * </p>
   *
   * @return a {@link ParseException} that contains details about the parsing
   *         error,
   *         including the unexpected token and the expected token sequences.
   */
  static public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[13];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 5; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1 << j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 13; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * Enable tracing.
   * <p>
   * This method is used to enable tracing during the parsing process.
   * Tracing can be helpful for debugging purposes, allowing the parser
   * to output detailed information about its internal state and the
   * parsing steps it is performing.
   * </p>
   * <p>
   * In the current implementation, this method does not perform any
   * actions, but it can be overridden or modified to include tracing
   * functionality.
   * </p>
   */
  static final public void enable_tracing() {
  }

  /**
   * Disable tracing.
   * <p>
   * This method is used to disable tracing during the parsing process.
   * Disabling tracing stops the parser from outputting detailed information
   * about its internal state and the parsing steps.
   * </p>
   * <p>
   * In the current implementation, this method does not perform any
   * actions, but it can be overridden or modified to include tracing
   * functionality.
   * </p>
   */
  static final public void disable_tracing() {
  }

}
