/*
 *  This file is part of "TweetyProject", a collection of Java libraries for
 *  logical aspects of artificial intelligence and knowledge representation.
 *
 *  TweetyProject is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  Copyright 2016 The TweetyProject Team <http://tweetyproject.org/contact/>
 */
/* Generated By:JavaCC: Do not edit this line. SimpleCharStream.java Version 5.0 */
/* JavaCCOptions:STATIC=true,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package org.tweetyproject.logics.rpcl.parser.rpclprobabilitydistributionparser;

/**
 * An implementation of interface CharStream, where the stream is assumed to
 * contain only ASCII characters (without unicode processing).
 */

public class SimpleCharStream
{
/** Whether parser is static. */
  public static final boolean staticFlag = true;
  /** varible */
  static int bufsize;
  /** varible */
  static int available;
  /** varible */
  static int tokenBegin;
  /** Position in buffer. */
  static public int bufpos = -1;
  /** varible */
  static protected int bufline[];
  /** varible */
  static protected int bufcolumn[];
  /** varible */
  static protected int column = 0;
  /** varible */
  static protected int line = 1;
  /** varible */
  static protected boolean prevCharIsCR = false;
  /** varible */
  static protected boolean prevCharIsLF = false;
  /** varible */
  static protected java.io.Reader inputStream;
  /** varible */
  static protected char[] buffer;
  /** varible */
  static protected int maxNextCharInd = 0;
  /** varible */
  static protected int inBuf = 0;
  /** varible */
  static protected int tabSize = 8;

  /**
   * Setter tabSize
   * @param i index
   */
  static protected void setTabSize(int i) { tabSize = i; }
  /**
   * Get Tabsize
   * @param i index
   * @return tabsize
   */
  static protected int getTabSize(int i) { return tabSize; }

  /**
   * Expand the buffer
   * @param wrapAround wrapAround
   */
  static protected void ExpandBuff(boolean wrapAround)
  {
    char[] newbuffer = new char[bufsize + 2048];
    int newbufline[] = new int[bufsize + 2048];
    int newbufcolumn[] = new int[bufsize + 2048];

    try
    {
      if (wrapAround)
      {
        System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
        System.arraycopy(buffer, 0, newbuffer, bufsize - tokenBegin, bufpos);
        buffer = newbuffer;

        System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
        System.arraycopy(bufline, 0, newbufline, bufsize - tokenBegin, bufpos);
        bufline = newbufline;

        System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
        System.arraycopy(bufcolumn, 0, newbufcolumn, bufsize - tokenBegin, bufpos);
        bufcolumn = newbufcolumn;

        maxNextCharInd = (bufpos += (bufsize - tokenBegin));
      }
      else
      {
        System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
        buffer = newbuffer;

        System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
        bufline = newbufline;

        System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
        bufcolumn = newbufcolumn;

        maxNextCharInd = (bufpos -= tokenBegin);
      }
    }
    catch (Throwable t)
    {
      throw new Error(t.getMessage());
    }


    bufsize += 2048;
    available = bufsize;
    tokenBegin = 0;
  }

  /**
   * Fill buffer
   * @throws java.io.IOException error
   */
  static protected void FillBuff() throws java.io.IOException
  {
    if (maxNextCharInd == available)
    {
      if (available == bufsize)
      {
        if (tokenBegin > 2048)
        {
          bufpos = maxNextCharInd = 0;
          available = tokenBegin;
        }
        else if (tokenBegin < 0)
          bufpos = maxNextCharInd = 0;
        else
          ExpandBuff(false);
      }
      else if (available > tokenBegin)
        available = bufsize;
      else if ((tokenBegin - available) < 2048)
        ExpandBuff(true);
      else
        available = tokenBegin;
    }

    int i;
    try {
      if ((i = inputStream.read(buffer, maxNextCharInd, available - maxNextCharInd)) == -1)
      {
        inputStream.close();
        throw new java.io.IOException();
      }
      else
        maxNextCharInd += i;
      return;
    }
    catch(java.io.IOException e) {
      --bufpos;
      backup(0);
      if (tokenBegin == -1)
        tokenBegin = bufpos;
      throw e;
    }
  }

/**
 * Start
 * @return begin token
 * @throws java.io.IOException error
 */
  static public char BeginToken() throws java.io.IOException
  {
    tokenBegin = -1;
    char c = readChar();
    tokenBegin = bufpos;

    return c;
  }

  /**
   * update
   * @param c char
   */
  static protected void UpdateLineColumn(char c)
  {
    column++;

    if (prevCharIsLF)
    {
      prevCharIsLF = false;
      line += (column = 1);
    }
    else if (prevCharIsCR)
    {
      prevCharIsCR = false;
      if (c == '\n')
      {
        prevCharIsLF = true;
      }
      else
        line += (column = 1);
    }

    switch (c)
    {
      case '\r' :
        prevCharIsCR = true;
        break;
      case '\n' :
        prevCharIsLF = true;
        break;
      case '\t' :
        column--;
        column += (tabSize - (column % tabSize));
        break;
      default :
        break;
    }

    bufline[bufpos] = line;
    bufcolumn[bufpos] = column;
  }

/** Read a character.
 * @return char
 * @throws java.io.IOException error
*/
  static public char readChar() throws java.io.IOException
  {
    if (inBuf > 0)
    {
      --inBuf;

      if (++bufpos == bufsize)
        bufpos = 0;

      return buffer[bufpos];
    }

    if (++bufpos >= maxNextCharInd)
      FillBuff();

    char c = buffer[bufpos];

    UpdateLineColumn(c);
    return c;
  }

  /**
   * @deprecated
   * @see #getEndLine
   * Getter column
   * @return the column
   */
  @Deprecated
  static public int getColumn() {
    return bufcolumn[bufpos];
  }

  /**
   * @deprecated
   * @see #getEndLine
   * Getter line
   * @return the line
   */
  @Deprecated
  static public int getLine() {
    return bufline[bufpos];
  }

 /**
 * Retrieves the column number where the current token ends.
 *
 * @return The column number of the end of the current token.
 */
static public int getEndColumn() {
  return bufcolumn[bufpos];
}

/**
* Retrieves the line number where the current token ends.
*
* @return The line number of the end of the current token.
*/
static public int getEndLine() {
  return bufline[bufpos];
}

/**
* Retrieves the column number where the current token begins.
*
* @return The column number of the beginning of the current token.
*/
static public int getBeginColumn() {
  return bufcolumn[tokenBegin];
}

/**
* Retrieves the line number where the current token begins.
*
* @return The line number of the beginning of the current token.
*/
static public int getBeginLine() {
  return bufline[tokenBegin];
}

/**
* Rewinds the input stream by a specified number of characters.
* <p>
* This method allows you to move backwards in the input stream, effectively undoing the reading
* of a specified number of characters. This is useful when you need to backtrack after realizing
* that a token was read incorrectly or that more context is needed to parse the input properly.
* </p>
*
* @param amount The number of characters to move backwards. This should be a positive integer.
*/
static public void backup(int amount) {
  inBuf += amount;
  if ((bufpos -= amount) < 0) {
      bufpos += bufsize;
  }

}

  /**
   * Constructor
   * @param dstream the reader
   * @param startline start line
   * @param startcolumn start column
   * @param buffersize buffer size
   */
  public SimpleCharStream(java.io.Reader dstream, int startline,
  int startcolumn, int buffersize)
  {
    if (inputStream != null)
      throw new Error("\n   ERROR: Second call to the constructor of a static SimpleCharStream.\n" +
      "       You must either use ReInit() or set the JavaCC option STATIC to false\n" +
      "       during the generation of this class.");
    inputStream = dstream;
    line = startline;
    column = startcolumn - 1;

    available = bufsize = buffersize;
    buffer = new char[buffersize];
    bufline = new int[buffersize];
    bufcolumn = new int[buffersize];
  }

    /**
   * Constructor
   * @param dstream the reader
   * @param startline start line
   * @param startcolumn start column
   */
  public SimpleCharStream(java.io.Reader dstream, int startline,
                          int startcolumn)
  {
    this(dstream, startline, startcolumn, 4096);
  }

  /**
   * Constructor
   * @param dstream the reader
   */
  public SimpleCharStream(java.io.Reader dstream)
  {
    this(dstream, 1, 1, 4096);
  }

  /**
   * Reinitialise
   * @param dstream the reader
   * @param startline start line
   * @param startcolumn start column
   * @param buffersize buffer size
   */
  public void ReInit(java.io.Reader dstream, int startline,
  int startcolumn, int buffersize)
  {
    inputStream = dstream;
    line = startline;
    column = startcolumn - 1;

    if (buffer == null || buffersize != buffer.length)
    {
      available = bufsize = buffersize;
      buffer = new char[buffersize];
      bufline = new int[buffersize];
      bufcolumn = new int[buffersize];
    }
    prevCharIsLF = prevCharIsCR = false;
    tokenBegin = inBuf = maxNextCharInd = 0;
    bufpos = -1;
  }

    /**
   * Reinitialise
   * @param dstream the reader
   * @param startline start line
   * @param startcolumn start column
   */
  public void ReInit(java.io.Reader dstream, int startline,
                     int startcolumn)
  {
    ReInit(dstream, startline, startcolumn, 4096);
  }

   /**
  * Reinitialise
  * @param dstream the reader
  */
  public void ReInit(java.io.Reader dstream)
  {
    ReInit(dstream, 1, 1, 4096);
  }
  /**
   * Constructor
   * @param dstream inout stream
   * @param encoding the string encoding
   * @param startline start line
   * @param startcolumn start column
   * @param buffersize buffer size
   * @throws java.io.UnsupportedEncodingException error
   */
  public SimpleCharStream(java.io.InputStream dstream, String encoding, int startline,
  int startcolumn, int buffersize) throws java.io.UnsupportedEncodingException
  {
    this(encoding == null ? new java.io.InputStreamReader(dstream) : new java.io.InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
  }

   /**
   * Constructor
   * @param dstream inout stream
   * @param startline start line
   * @param startcolumn start column
   * @param buffersize buffer size
   */
  public SimpleCharStream(java.io.InputStream dstream, int startline,
  int startcolumn, int buffersize)
  {
    this(new java.io.InputStreamReader(dstream), startline, startcolumn, buffersize);
  }

    /**
   * Constructor
   * @param dstream inout stream
   * @param encoding the string encoding
   * @param startline start line
   * @param startcolumn start column
   * @throws java.io.UnsupportedEncodingException error
   */
  public SimpleCharStream(java.io.InputStream dstream, String encoding, int startline,
                          int startcolumn) throws java.io.UnsupportedEncodingException
  {
    this(dstream, encoding, startline, startcolumn, 4096);
  }

    /**
   * Constructor
   * @param dstream inout stream
   * @param startline start line
   * @param startcolumn start column
   */
  public SimpleCharStream(java.io.InputStream dstream, int startline,
                          int startcolumn)
  {
    this(dstream, startline, startcolumn, 4096);
  }

    /**
   * Constructor
   * @param dstream inout stream
   * @param encoding the string encoding
   * @throws java.io.UnsupportedEncodingException error
   */
  public SimpleCharStream(java.io.InputStream dstream, String encoding) throws java.io.UnsupportedEncodingException
  {
    this(dstream, encoding, 1, 1, 4096);
  }

  /**
   * Constructor
   * @param dstream inout stream
   */
  public SimpleCharStream(java.io.InputStream dstream)
  {
    this(dstream, 1, 1, 4096);
  }

  /**
   * Reinitialise
   *@param dstream inout stream
   * @param encoding the string encoding
   * @param startline start line
   * @param startcolumn start column
   * @param buffersize buffer size
   * @throws java.io.UnsupportedEncodingException error
   */
  public void ReInit(java.io.InputStream dstream, String encoding, int startline,
                          int startcolumn, int buffersize) throws java.io.UnsupportedEncodingException
  {
    ReInit(encoding == null ? new java.io.InputStreamReader(dstream) : new java.io.InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
  }

  /**
   * Reinitialise
   *@param dstream inout stream
   * @param startline start line
   * @param startcolumn start column
   * @param buffersize buffer size
   */
  public void ReInit(java.io.InputStream dstream, int startline,
                          int startcolumn, int buffersize)
  {
    ReInit(new java.io.InputStreamReader(dstream), startline, startcolumn, buffersize);
  }

  /**
   * Reinitialise
   *@param dstream inout stream
   * @param encoding the string encoding
   * @throws java.io.UnsupportedEncodingException error
   */
  public void ReInit(java.io.InputStream dstream, String encoding) throws java.io.UnsupportedEncodingException
  {
    ReInit(dstream, encoding, 1, 1, 4096);
  }

  /**
   * Reinitialise
   *@param dstream inout stream
   */
  public void ReInit(java.io.InputStream dstream)
  {
    ReInit(dstream, 1, 1, 4096);
  }
  /**
   * Reinitialise
   *@param dstream inout stream
   * @param encoding the string encoding
   * @param startline start line
   * @param startcolumn start column
   * @throws java.io.UnsupportedEncodingException error
   */
  public void ReInit(java.io.InputStream dstream, String encoding, int startline,
                     int startcolumn) throws java.io.UnsupportedEncodingException
  {
    ReInit(dstream, encoding, startline, startcolumn, 4096);
  }
  /**
   * Reinitialise
   *@param dstream inout stream
   * @param startline start line
   * @param startcolumn start column
   */
  public void ReInit(java.io.InputStream dstream, int startline,
                     int startcolumn)
  {
    ReInit(dstream, startline, startcolumn, 4096);
  }
  /** Get token literal value.
   * @return image
  */
  static public String GetImage()
  {
    if (bufpos >= tokenBegin)
      return new String(buffer, tokenBegin, bufpos - tokenBegin + 1);
    else
      return new String(buffer, tokenBegin, bufsize - tokenBegin) +
                            new String(buffer, 0, bufpos + 1);
  }

  /** Get the suffix.
   * @param len length
   * @return suffix
  */
  static public char[] GetSuffix(int len)
  {
    char[] ret = new char[len];

    if ((bufpos + 1) >= len)
      System.arraycopy(buffer, bufpos - len + 1, ret, 0, len);
    else
    {
      System.arraycopy(buffer, bufsize - (len - bufpos - 1), ret, 0,
                                                        len - bufpos - 1);
      System.arraycopy(buffer, 0, ret, len - bufpos - 1, bufpos + 1);
    }

    return ret;
  }

  /** Reset buffer when finished. */
  static public void Done()
  {
    buffer = null;
    bufline = null;
    bufcolumn = null;
  }


  /**
   * Method to adjust line and column numbers for the start of a token.
   * @param newLine line
   * @param newCol column
   */
  static public void adjustBeginLineColumn(int newLine, int newCol)
  {
    int start = tokenBegin;
    int len;

    if (bufpos >= tokenBegin)
    {
      len = bufpos - tokenBegin + inBuf + 1;
    }
    else
    {
      len = bufsize - tokenBegin + bufpos + 1 + inBuf;
    }

    int i = 0, j = 0, k = 0;
    int nextColDiff = 0, columnDiff = 0;

    while (i < len && bufline[j = start % bufsize] == bufline[k = ++start % bufsize])
    {
      bufline[j] = newLine;
      nextColDiff = columnDiff + bufcolumn[k] - bufcolumn[j];
      bufcolumn[j] = newCol + columnDiff;
      columnDiff = nextColDiff;
      i++;
    }

    if (i < len)
    {
      bufline[j] = newLine++;
      bufcolumn[j] = newCol + columnDiff;

      while (i++ < len)
      {
        if (bufline[j = start % bufsize] != bufline[++start % bufsize])
          bufline[j] = newLine++;
        else
          bufline[j] = newLine;
      }
    }

    line = bufline[j];
    column = bufcolumn[j];
  }

}
/* JavaCC - OriginalChecksum=217886d9047f026c7b7fc21c87f15b3d (do not edit this line) */
