/* Generated By:JavaCC: Do not edit this line. JJTASPParserState.java Version 5.0 */
package org.tweetyproject.lp.asp.parser;


/**
 * Manages the state of the abstract syntax tree (AST) during parsing in the ASP parser.
 * <p>
 * This class handles the stack of nodes being constructed as part of the parsing process,
 * including operations such as pushing and popping nodes, managing marks that indicate
 * different node scopes, and tracking whether nodes have been created.
 * </p>
 */
public class JJTASPParserState {

  /** nodes */
  private java.util.List<Node> nodes;
  /** marks */
  private java.util.List<Integer> marks;

  /** sp */
  private int sp;        // number of nodes on stack
  /** current mark */
  private int mk;        // current mark
  /** node created */
  private boolean node_created;

  /**
   * Constructs a new {@code JJTASPParserState} object with an empty node stack and mark list.
   */
  public JJTASPParserState() {
      nodes = new java.util.ArrayList<Node>();
      marks = new java.util.ArrayList<Integer>();
      sp = 0;
      mk = 0;
  }

  /**
   * Determines whether the current node was actually closed and pushed onto the stack.
   * <p>
   * This method should only be called in the final user action of a node scope.
   * </p>
   *
   * @return {@code true} if the current node was closed and pushed, {@code false} otherwise.
   */
  public boolean nodeCreated() {
      return node_created;
  }

  /**
   * Reinitializes the node stack and mark list. This method is called automatically by the parser's {@code ReInit()} method.
   */
  public void reset() {
      nodes.clear();
      marks.clear();
      sp = 0;
      mk = 0;
  }

  /**
   * Returns the root node of the AST. This method should only be called after a successful parse.
   *
   * @return The root {@link Node} of the AST.
   */
  public Node rootNode() {
      return nodes.get(0);
  }

  /**
   * Pushes a node onto the stack.
   *
   * @param n The {@link Node} to be pushed onto the stack.
   */
  public void pushNode(Node n) {
      nodes.add(n);
      ++sp;
  }

  /**
   * Returns the node on the top of the stack and removes it from the stack.
   *
   * @return The {@link Node} on the top of the stack.
   */
  public Node popNode() {
      if (--sp < mk) {
          mk = marks.remove(marks.size() - 1);
      }
      return nodes.remove(nodes.size() - 1);
  }

  /**
   * Returns the node currently on the top of the stack without removing it.
   *
   * @return The {@link Node} currently on the top of the stack.
   */
  public Node peekNode() {
      return nodes.get(nodes.size() - 1);
  }

  /**
   * Returns the number of children on the stack in the current node scope.
   *
   * @return The number of children on the stack in the current node scope.
   */
  public int nodeArity() {
      return sp - mk;
  }

  /**
   * Clears the current node scope by popping all nodes from the stack that belong to the current scope.
   *
   * @param n The {@link Node} representing the current scope to be cleared.
   */
  public void clearNodeScope(Node n) {
      while (sp > mk) {
          popNode();
      }
      mk = marks.remove(marks.size() - 1);
  }

  /**
   * Opens a new node scope by marking the current stack position.
   *
   * @param n The {@link Node} representing the new scope being opened.
   */
  public void openNodeScope(Node n) {
      marks.add(mk);
      mk = sp;
      n.jjtOpen();
  }

  /**
   * Closes the current node scope and constructs a definite node from a specified number of children.
   * <p>
   * The specified number of nodes are popped from the stack and made the children of the definite node.
   * The definite node is then pushed onto the stack.
   * </p>
   *
   * @param n The {@link Node} representing the node scope being closed.
   * @param num The number of children nodes to be added to the closed node.
   */
  public void closeNodeScope(Node n, int num) {
      mk = marks.remove(marks.size() - 1);
      while (num-- > 0) {
          Node c = popNode();
          c.jjtSetParent(n);
          n.jjtAddChild(c, num);
      }
      n.jjtClose();
      pushNode(n);
      node_created = true;
  }

  /** A conditional node is constructed if its condition is true.
   * Allthe nodes that have been pushed since the node was opened are
   * made children of the conditional node, which is then pushed
   * on to the stack.
   * If the condition is false the node is notconstructed and they are left on the stack
   * @param n node
   * @param condition condition
     */
  public void closeNodeScope(Node n, boolean condition) {
    if (condition) {
      int a = nodeArity();
      mk = marks.remove(marks.size()-1);
      while (a-- > 0) {
        Node c = popNode();
        c.jjtSetParent(n);
        n.jjtAddChild(c, a);
      }
      n.jjtClose();
      pushNode(n);
      node_created = true;
    } else {
      mk = marks.remove(marks.size()-1);
      node_created = false;
    }
  }
}
/* JavaCC - OriginalChecksum=e3329237249665f1d381715438c5bc9d (do not edit this line) */
