/*
 *  This file is part of "TweetyProject", a collection of Java libraries for
 *  logical aspects of artificial intelligence and knowledge representation.
 *
 *  TweetyProject is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  Copyright 2016 The TweetyProject Team <http://tweetyproject.org/contact/>
 */
package org.tweetyproject.commons;

import java.util.Collection;

/**
 * An abstract interpretation for some logical language.
 * @author Matthias Thimm
 * @param <B> the type of belief bases
 * @param <S> the type of formulas
 */
public abstract class AbstractInterpretation<B extends BeliefBase, S extends Formula> implements Interpretation<B,S> {

	/**
	 * Default Constructor
	 */
	public AbstractInterpretation(){

	}

	/**
	 * Checks whether this interpretation satisfies all given formulas.
	 * @param formulas a collection of formulas.
	 * @return "true" if this interpretation satisfies all given formulas.
	 * @throws IllegalArgumentException if at least one formula does not correspond
	 * 		to the expected language.
	 */
	@Override
	public boolean satisfies(Collection<S> formulas) throws IllegalArgumentException{
		for(S f: formulas)
			if(!this.satisfies(f))
				return false;
		return true;
	}
}
