/*
 *  This file is part of "TweetyProject", a collection of Java libraries for
 *  logical aspects of artificial intelligence and knowledge representation.
 *
 *  TweetyProject is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  Copyright 2016 The TweetyProject Team <http://tweetyproject.org/contact/>
 */
/* Generated By:JavaCC: Do not edit this line. Token.java Version 5.0 */
/* JavaCCOptions:TOKEN_EXTENDS=,KEEP_LINE_COL=null,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package org.tweetyproject.preferences.io;

/**
 * Describes the input token stream.
 */

public class Token implements java.io.Serializable {

  /** The version identifier for this Serializable class. */
  private static final long serialVersionUID = 1L;

  /** An integer that describes the kind of this token. This is typically set by the parser. */
  public int kind;

  /** The line number of the first character of this token. */
  public int beginLine;

  /** The column number of the first character of this token. */
  public int beginColumn;

  /** The line number of the last character of this token. */
  public int endLine;

  /** The column number of the last character of this token. */
  public int endColumn;

  /** The string image of the token. */
  public String image;

  /**
   * A reference to the next regular (non-special) token in the input stream.
   * This field is set to null if this is the last token or if the token manager has not read tokens beyond this one.
   */
  public Token next;

  /**
   * A reference to special tokens that occur before this token but after the
   * immediately preceding regular (non-special) token. Special tokens are used
   * for syntactic sugar and are not part of the main token stream.
   */
  public Token specialToken;

  /**
   * An optional attribute value of the Token. Tokens that are not used as syntactic sugar
   * will often contain meaningful values that will be used later on by the compiler or
   * interpreter. This attribute value is often different from the image.
   *
   * @return the attribute value of the token, or {@code null} if not applicable.
   */
  public Object getValue() {
    return null;
  }

  /** No-argument constructor for {@code Token}. */
  public Token() {}

  /**
   * Constructs a new token for the specified kind.
   *
   * @param kind the kind of the token.
   */
  public Token(int kind) {
    this(kind, null);
  }

  /**
   * Constructs a new token for the specified kind and image.
   *
   * @param kind  the kind of the token.
   * @param image the image of the token.
   */
  public Token(int kind, String image) {
    this.kind = kind;
    this.image = image;
  }

  /**
   * Returns the string image of the token.
   *
   * @return the image of the token.
   */
  @Override
  public String toString() {
    return image;
  }

  /**
   * Returns a new {@code Token} object. This method can be overridden to create
   * instances of subclasses based on the value of {@code ofKind}.
   *
   * <p>
   * By default, this method returns a {@code Token} instance. Subclasses can be
   * created by adding cases to the switch statement for specific token kinds.
   * </p>
   *
   * @param ofKind the kind of token to create.
   * @param image  the image of the token.
   * @return a new {@code Token} instance.
   */
  public static Token newToken(int ofKind, String image) {
    switch(ofKind) {
      default : return new Token(ofKind, image);
    }
  }

  /**
   * Returns a new {@code Token} object with the specified kind.
   *
   * @param ofKind the kind of token to create.
   * @return a new {@code Token} instance.
   */
  public static Token newToken(int ofKind) {
    return newToken(ofKind, null);
  }

}
/* JavaCC - OriginalChecksum=cd46cabafc8de4dcaf475c4d32aad87e (do not edit this line) */
