/** Generated By:JavaCC: Do not edit this line. DelpParser.java */
package org.tweetyproject.arg.delp.parser;

import org.tweetyproject.arg.delp.syntax.DefeasibleLogicProgram;
import org.tweetyproject.arg.delp.syntax.DefeasibleRule;
import org.tweetyproject.arg.delp.syntax.DelpFact;
import org.tweetyproject.arg.delp.syntax.StrictRule;
import org.tweetyproject.commons.Formula;
import org.tweetyproject.commons.Parser;
import org.tweetyproject.commons.ParserException;
import org.tweetyproject.logics.commons.syntax.Constant;
import org.tweetyproject.logics.commons.syntax.Predicate;
import org.tweetyproject.logics.commons.syntax.Variable;
import org.tweetyproject.logics.commons.syntax.interfaces.Term;
import org.tweetyproject.logics.fol.syntax.FolAtom;
import org.tweetyproject.logics.fol.syntax.FolFormula;
import org.tweetyproject.logics.fol.syntax.FolSignature;
import org.tweetyproject.logics.fol.syntax.Negation;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/***
 * This class implements a parser for defeasible logic programs. The BNF for
 * defeasible
 * logic program files is given by (start symbol is THEORY)
 * <br>
 *
 * <pre>
 * THEORY  		::== (EXPRESSION)+
 * EXPRESSION 		::== FACT | STRICTRULE | DEFEASIBLERULE
 * FACT 			::== LITERAL + "."
 * STRICTRULE 		::== LITERAL + "&lt;-" + RULEBODY + "."
 * DEFEASIBLERULE 	::== LITERAL + "-&lt;" + RULEBODY + "."
 * RULEBODY 		::== LITERAL | LITERAL + "," + RULEBODY
 * LITERAL 		::== "~" + ATOM | ATOM
 * ATOM 			::== PREDICATE | PREDICATE + "(" + TERMLIST + ")"
 * TERMLIST 		::== TERM | TERM + "," + TERMLIST
 * TERM 			::== VARIABLE | CONSTANT | QUOTED_STRING
 *
 * PREDICATE is a sequence of symbols from {a,...,z,A,...,Z,0,...,9,_,-} with a letter at the beginning.
 * VARIABLE is a sequence of symbols from {a,...,z,A,...,Z,0,...,9,_,-} with an uppercase letter at the beginning.
 * CONSTANT is  a sequence of symbols from {a,...,z,A,...,Z,0,...,9,_,-} with an lowercase letter at the beginning.
 * QUOTED_STRING is all characters between double quotes.
 * </pre>
 */
@SuppressWarnings("all")
public class DelpParser extends Parser<DefeasibleLogicProgram, Formula> implements DelpParserConstants {

  /** The logical signature for the defeasible logic program. */
  private FolSignature signature = new FolSignature();

  /**
   * Constructs a new `DelpParser` instance with an empty input reader.
   */
  public DelpParser() {
    this(new StringReader(""));
  }

  /**
   * Parses a defeasible logic program from the given reader.
   *
   * <p>
   * This method initializes the parser with the provided reader and
   * parses the input to construct a {@link DefeasibleLogicProgram}. It uses
   * the current logical signature to guide the parsing process.
   *
   * @param reader The reader from which the defeasible logic program is read.
   * @return A {@link DefeasibleLogicProgram} constructed from the input.
   * @throws ParserException If an error occurs during parsing.
   */
  public DefeasibleLogicProgram parseBeliefBase(Reader reader) throws ParserException {
    try {
      ReInit(reader);
      return this.Theory(this.signature);
    } catch (ParseException e) {
      throw new ParserException(e);
    }
  }

  /**
   * A formula here is a Literal, that is an Atom or a negated Atom.
   * The class DelpQuery encapsulates the following.
   * The Atom is either a DeLP predicate (a predicate with arity > 0) or a
   * DeLP constant or variable (a predicate with arity == 0).
   * In the case of a real predicate, test all arguments whether they are
   * DeLP variables (= begin with upper case letter) or DeLP constants.
   *
   * All predicates and constants need to be present in the current signature to
   * parse.
   *
   * @param reader the reader to parse from
   * @return a Formula, which is always a DelpQuery in this implementation,
   *         that has been successfully parsed with the current signature in mind
   * @throws ParserException if the reader cannot be successfully parsed into a
   *                         formula
   */
  public Formula parseFormula(Reader reader) throws ParserException {
    try {
      ReInit(reader);
      FolFormula fol = this.Formula(this.signature);
      // check that formula contains only known constants and predicates:
      FolAtom atom = (FolAtom) fol.getAtoms().iterator().next();
      Predicate p = atom.getPredicate();
      if (signature.getPredicate(p.getName()) == null)
        throw new ParseException("Formula contains unknown predicate '" + p + "'");
      if (signature.getPredicate(p.getName()).getArity() != p.getArity())
        throw new ParseException("Formula contains predicate '" + p + "' with non-matching arity");
      for (Term t : atom.getArguments()) {
        if (t instanceof Constant &&
            signature.getConstant(((Constant) t).get()) == null)
          throw new ParseException("Formula constains unknown constant '" + t + "'");
      }
      return fol;
    } catch (ParseException e) {
      throw new ParserException(e);
    }
  }

  /**
   *
   * Return the signature
   *
   * @return the signature
   */
  public FolSignature getSignature() {
    return this.signature;
  }

  /**
   * Creates a constant and adds it to the provided signature if necessary.
   * Also ensures that the constant is treated consistently with predicates, where
   * predicates with an arity of 0 are considered constants.
   *
   * @param image     The name of the constant to create and add.
   * @param delp      The defeasible logic program being constructed (may be null
   *                  if not applicable).
   * @param signature The signature that defines the vocabulary of the logic
   *                  program.
   * @return A {@link Constant} instance created with the specified name.
   * @throws ParseException If the signature contains a predicate with the same
   *                        name but a non-zero arity.
   */
  private Constant createConstant(String image, DefeasibleLogicProgram delp, FolSignature signature)
      throws ParseException {
    // treat constants also as predicates with arity = 0 to be consistent with
    // parsing queries as formulae:

    // only add constant/predicate to signature if parsing DeLP!
    Constant constant = new Constant(image);
    if (delp != null && !signature.containsConstant(image))
      signature.add(constant);
    Predicate predicate = new Predicate(image);
    if (delp != null && !signature.containsPredicate(image))
      signature.add(predicate);
    if (signature.containsPredicate(image) && signature.getPredicate(image).getArity() != 0)
      throw new ParseException("Wrong arity of predicate as constant '" + image + "'");
    return constant;
  }

  /**
   * Parses a defeasible logic program from a given signature.
   *
   * @param signature The signature that defines the vocabulary of the logic
   *                  program.
   * @return A {@link DefeasibleLogicProgram} instance representing the parsed
   *         program.
   * @throws ParseException If an error occurs during parsing.
   */
  final public DefeasibleLogicProgram Theory(FolSignature signature) throws ParseException {
    DefeasibleLogicProgram delp = new DefeasibleLogicProgram();
    label_1: while (true) {
      Expression(delp, signature);
      switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case NAME:
        case 12:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
      }
    }
    jj_consume_token(0);
    {
      if (true)
        return delp;
    }
    throw new Error("Missing return statement in function");
  }

  /**
   * Parses an expression in the defeasible logic program.
   *
   * @param delp      The defeasible logic program to which parsed components are
   *                  added.
   * @param signature The signature that defines the vocabulary of the logic
   *                  program.
   * @throws ParseException If an error occurs during parsing.
   */
  final public void Expression(DefeasibleLogicProgram delp, FolSignature signature) throws ParseException {
    FolFormula lit;
    Set<FolFormula> body = new HashSet<FolFormula>();
    FolFormula b;
    lit = Literal(delp, signature);
    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case 8:
        jj_consume_token(8);
        delp.add(new DelpFact(lit));
        break;
      case 9:
        jj_consume_token(9);
        b = Literal(delp, signature);
        body.add(b);
        label_2: while (true) {
          switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 10:
              ;
              break;
            default:
              jj_la1[1] = jj_gen;
              break label_2;
          }
          jj_consume_token(10);
          b = Literal(delp, signature);
          body.add(b);
        }
        jj_consume_token(8);
        delp.add(new StrictRule(lit, body));
        break;
      case 11:
        jj_consume_token(11);
        b = Literal(delp, signature);
        body.add(b);
        label_3: while (true) {
          switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 10:
              ;
              break;
            default:
              jj_la1[2] = jj_gen;
              break label_3;
          }
          jj_consume_token(10);
          b = Literal(delp, signature);
          body.add(b);
        }
        jj_consume_token(8);
        delp.add(new DefeasibleRule(lit, body));
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
    }
  }

  /**
   * Parses a formula from the given signature.
   *
   * @param signature The signature that defines the vocabulary of the logic
   *                  program.
   * @return A {@link FolFormula} representing the parsed formula.
   * @throws ParseException If an error occurs during parsing.
   */
  final public FolFormula Formula(FolSignature signature) throws ParseException {
    FolFormula lit;
    lit = Literal(null, signature);
    jj_consume_token(0);
    {
      if (true)
        return lit;
    }
    throw new Error("Missing return statement in function");
  }

  /**
   * Parses a literal, which could be an atom or its negation.
   *
   * @param delp      The defeasible logic program to which the literal might be
   *                  added.
   * @param signature The signature that defines the vocabulary of the logic
   *                  program.
   * @return A {@link FolFormula} representing the parsed literal.
   * @throws ParseException If an error occurs during parsing.
   */
  final public FolFormula Literal(DefeasibleLogicProgram delp, FolSignature signature) throws ParseException {
    FolAtom atom;
    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case NAME:
        atom = Atom(delp, signature); {
        if (true)
          return atom;
      }
        break;
      case 12:
        jj_consume_token(12);
        atom = Atom(delp, signature); {
        if (true)
          return new Negation(atom);
      }
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  /**
   * Parses an atom (predicate with optional terms) from the input.
   *
   * <p>
   * This method constructs a {@link FolAtom} by parsing a predicate name followed
   * by a
   * sequence of terms, if present. The predicate is added to the signature if it
   * is not
   * already present, and its arity is checked for correctness. If the arity is
   * incorrect,
   * a {@link ParseException} is thrown.
   * </p>
   *
   * @param delp      The defeasible logic program to which the predicate might be
   *                  added.
   * @param signature The logical signature to which the predicate might be added.
   * @return A {@link FolAtom} constructed from the parsed predicate and terms.
   * @throws ParseException If an error occurs during parsing, such as an
   *                        incorrect predicate arity.
   */
  final public FolAtom Atom(DefeasibleLogicProgram delp, FolSignature signature) throws ParseException {
    Token p;
    List<Term<?>> terms = new ArrayList<Term<?>>();
    Term<?> t;
    p = jj_consume_token(NAME);
    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case 13:
        jj_consume_token(13);
        t = Term(delp, signature);
        terms.add(t);
        label_4: while (true) {
          switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 10:
              ;
              break;
            default:
              jj_la1[5] = jj_gen;
              break label_4;
          }
          jj_consume_token(10);
          t = Term(delp, signature);
          terms.add(t);
        }
        jj_consume_token(14);
        break;
      default:
        jj_la1[6] = jj_gen;
        ;
    }
    // only add predicate to signature if parsing DeLP!
    Predicate predicate = new Predicate(p.image, terms.size());
    if (delp != null && !signature.containsPredicate(p.image))
      signature.add(predicate);
    if (signature.containsPredicate(p.image) && signature.getPredicate(p.image).getArity() != terms.size()) {
      if (true)
        throw new ParseException("Wrong arity of predicate '" + p.image + "'");
    }
    {
      if (true)
        return new FolAtom(predicate, terms);
    }
    throw new Error("Missing return statement in function");
  }

  /**
   * Parses a term (either a variable or a constant) from the input.
   *
   * <p>
   * This method constructs a {@link Term} based on the input token. It handles
   * variables
   * (identified by uppercase names) and constants (both plain and quoted). If a
   * quoted term
   * is encountered, the quotes are removed before creating the constant.
   * </p>
   *
   * @param delp      The defeasible logic program used for creating constants (if
   *                  needed).
   * @param signature The logical signature used for creating constants (if
   *                  needed).
   * @return A {@link Term} constructed from the parsed token.
   * @throws ParseException If an error occurs during parsing.
   */
  final public Term Term(DefeasibleLogicProgram delp, FolSignature signature) throws ParseException {
    Token t;
    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
      case NAME:
        t = jj_consume_token(NAME);
        if (Character.isUpperCase(t.image.charAt(0))) {
          if (true)
            return new Variable(t.image);
        } {
        if (true)
          return createConstant(t.image, delp, signature);
      }
        break;
      case QUOTED:
        t = jj_consume_token(QUOTED);
        // get rid of quotes:
        String text = t.image.substring(1, t.image.length() - 1); {
        if (true)
          return createConstant(text, delp, signature);
      }
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  /*** Generated Token Manager. */
  public DelpParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /*** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  /**
   * The current token index in the lookahead process.
   */
  private int jj_ntk;

  /**
   * The current generation number used for lookahead operations.
   */
  private int jj_gen;

  /**
   * An array used for storing lookahead values at specific points during parsing.
   */
  final private int[] jj_la1 = new int[8];

  /**
   * A static array used for initialization of lookahead values.
   */
  static private int[] jj_la1_0;

  static {
    jj_la1_init_0();
  }

  /**
   * Initializes the static array of lookahead values with predefined values.
   */
  private static void jj_la1_init_0() {
    jj_la1_0 = new int[] { 0x1040, 0x400, 0x400, 0xb00, 0x1040, 0x400, 0x2000, 0xc0 };
  }

/**
     * Creates a new parser instance with the specified input stream.
     *
     * @param stream The input stream to be used by the parser.
     */
    public DelpParser(java.io.InputStream stream) {
      this(stream, null);
  }

  /**
   * Creates a new parser instance with the specified input stream and character encoding.
   *
   * @param stream The input stream to be used by the parser.
   * @param encoding The character encoding of the input stream. If {@code null}, the default encoding is used.
   */
  public DelpParser(java.io.InputStream stream, String encoding) {
      try {
          jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
      } catch (java.io.UnsupportedEncodingException e) {
          throw new RuntimeException(e);
      }
      token_source = new DelpParserTokenManager(jj_input_stream);
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 8; i++)
          jj_la1[i] = -1;
  }

  /**
   * Reinitializes the parser with a new input stream.
   *
   * @param stream The new input stream to be used by the parser.
   */
  public void ReInit(java.io.InputStream stream) {
      ReInit(stream, null);
  }

  /**
   * Reinitializes the parser with a new input stream and character encoding.
   *
   * @param stream The new input stream to be used by the parser.
   * @param encoding The character encoding of the new input stream. If {@code null}, the default encoding is used.
   */
  public void ReInit(java.io.InputStream stream, String encoding) {
      try {
          jj_input_stream.ReInit(stream, encoding, 1, 1);
      } catch (java.io.UnsupportedEncodingException e) {
          throw new RuntimeException(e);
      }
      token_source.ReInit(jj_input_stream);
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 8; i++)
          jj_la1[i] = -1;
  }

  /**
   * Creates a new parser instance with the specified reader.
   *
   * @param stream The reader to be used by the parser.
   */
  public DelpParser(java.io.Reader stream) {
      jj_input_stream = new SimpleCharStream(stream, 1, 1);
      token_source = new DelpParserTokenManager(jj_input_stream);
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 8; i++)
          jj_la1[i] = -1;
  }

  /**
   * Reinitializes the parser with a new reader.
   *
   * @param stream The new reader to be used by the parser.
   */
  public void ReInit(java.io.Reader stream) {
      jj_input_stream.ReInit(stream, 1, 1);
      token_source.ReInit(jj_input_stream);
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 8; i++)
          jj_la1[i] = -1;
  }

  /**
   * Creates a new parser instance with the specified token manager.
   *
   * @param tm The token manager to be used by the parser.
   */
  public DelpParser(DelpParserTokenManager tm) {
      token_source = tm;
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 8; i++)
          jj_la1[i] = -1;
  }

  /**
   * Reinitializes the parser with a new token manager.
   *
   * @param tm The new token manager to be used by the parser.
   */
  public void ReInit(DelpParserTokenManager tm) {
      token_source = tm;
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 8; i++)
          jj_la1[i] = -1;
  }

  /**
   * Consumes a token from the input stream if it matches the expected kind.
   *
   * <p>
   * This method advances the token pointer and checks if the current token
   * matches
   * the expected kind. If it does, it returns the token and increments the
   * generation
   * counter. If the token does not match the expected kind, it resets the token
   * to the
   * previous state and throws a {@link ParseException}.
   * </p>
   *
   * @param kind The expected kind of token to be consumed.
   * @return The token that was consumed.
   * @throws ParseException If the current token does not match the expected kind.
   */
  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null)
      token = token.next;
    else
      token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

/**
 * Retrieves the next token in the input stream.
 * <p>
 * This method advances to the next token by either using the previously
 * cached next token or fetching a new token from the token source if
 * there is no cached next token. The token stream is updated and the
 * token index and generation are incremented accordingly.
 * </p>
 *
 * @return The next {@link Token} in the input stream.
 */
final public Token getNextToken() {
  if (token.next != null)
      token = token.next;
  else
      token = token.next = token_source.getNextToken();
  jj_ntk = -1;
  jj_gen++;
  return token;
}

/**
* Retrieves a specific token from the input stream by its index.
* <p>
* This method traverses the token stream to reach the token at the specified
* index. If the token at the given index is not already available, it fetches
* the necessary tokens from the token source until the desired token is reached.
* </p>
*
* @param index The zero-based index of the token to retrieve.
* @return The {@link Token} at the specified index in the input stream.
*/
final public Token getToken(int index) {
  Token t = token;
  for (int i = 0; i < index; i++) {
      if (t.next != null)
          t = t.next;
      else
          t = t.next = token_source.getNextToken();
  }
  return t;
}


  /**
   * Retrieves the kind of the next token without consuming it.
   *
   * <p>
   * This method checks if the next token has been previously retrieved. If not,
   * it fetches
   * the next token from the token source and updates the cached next token kind.
   * It returns the
   * kind of the next token.
   * </p>
   *
   * @return The kind of the next token.
   */
  private int jj_ntk() {
    if ((jj_nt = token.next) == null)
      return (jj_ntk = (token.next = token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  /**
   * List of arrays representing the expected token sequences at various points in
   * the grammar.
   *
   * <p>
   * This field is used for handling parse exceptions by providing information
   * about the expected
   * tokens at the point of error. Each array represents a set of expected tokens
   * for a particular
   * position in the grammar.
   * </p>
   */
  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();

  /**
   * Current array of expected token kinds.
   *
   * <p>
   * This field represents the expected token kinds at a particular point in the
   * parsing process.
   * It is used in conjunction with `jj_expentries` to manage expected tokens and
   * generate parse
   * exception messages.
   * </p>
   */
  private int[] jj_expentry;

  /**
   * The kind of the current token being processed or expected.
   *
   * <p>
   * This field stores the kind of token that is currently being processed or that
   * was expected
   * at the point of a parsing error. It helps in managing and verifying token
   * types during parsing.
   * </p>
   */
  private int jj_kind = -1;

  /** Generate ParseException.
   * @return the ParseException
  */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[15];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 8; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1 << j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 15; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
