/*
 *  This file is part of "TweetyProject", a collection of Java libraries for
 *  logical aspects of artificial intelligence and knowledge representation.
 *
 *  TweetyProject is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  Copyright 2016 The TweetyProject Team <http://tweetyproject.org/contact/>
 */
/* Generated By:JavaCC: Do not edit this line. Token.java Version 5.0 */
/* JavaCCOptions:TOKEN_EXTENDS=,KEEP_LINE_COL=null,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package org.tweetyproject.logics.rpcl.parser.rpclprobabilitydistributionparser;

/**
 * Describes the input token stream.
 */

public class Token implements java.io.Serializable {

  /**
   * The version identifier for this Serializable class.
   * Increment only if the <i>serialized</i> form of the
   * class changes.
   */
  private static final long serialVersionUID = 1L;

  /**
   * An integer that describes the kind of this token.  This numbering
   * system is determined by JavaCCParser, and a table of these numbers is
   * stored in the file ...Constants.java.
   */
  public int kind;

  /** The line number of the first character of this Token. */
  public int beginLine;
  /** The column number of the first character of this Token. */
  public int beginColumn;
  /** The line number of the last character of this Token. */
  public int endLine;
  /** The column number of the last character of this Token. */
  public int endColumn;

  /**
   * The string image of the token.
   */
  public String image;

  /**
   * A reference to the next regular (non-special) token from the input
   * stream.  If this is the last token from the input stream, or if the
   * token manager has not read tokens beyond this one, this field is
   * set to null.  This is true only if this token is also a regular
   * token.  Otherwise, see below for a description of the contents of
   * this field.
   */
  public Token next;

  /**
   * This field is used to access special tokens that occur prior to this
   * token, but after the immediately preceding regular (non-special) token.
   * If there are no such special tokens, this field is set to null.
   * When there are more than one such special token, this field refers
   * to the last of these special tokens, which in turn refers to the next
   * previous special token through its specialToken field, and so on
   * until the first special token (whose specialToken field is null).
   * The next fields of special tokens refer to other special tokens that
   * immediately follow it (without an intervening regular token).  If there
   * is no such token, this field is null.
   */
  public Token specialToken;

/**
     * An optional attribute value of the token.
     * <p>
     * Tokens that are not used merely as syntactic sugar often contain meaningful values that will be
     * used later by the compiler or interpreter. This attribute value may differ from the token's image.
     * Subclasses of {@code Token} can override this method to return a meaningful value if required.
     * </p>
     *
     * @return The value associated with this token, or {@code null} by default.
     */
    public Object getValue() {
      return null;
  }

  /**
   * No-argument constructor.
   * <p>
   * Initializes a new {@code Token} with no specific kind or image.
   * </p>
   */
  public Token() {}

  /**
   * Constructs a new token for the specified kind.
   * <p>
   * This constructor initializes a {@code Token} with the specified kind and a {@code null} image.
   * The kind typically represents the type of token, such as an identifier, keyword, or operator.
   * </p>
   *
   * @param kind The kind of token.
   */
  public Token(int kind) {
      this(kind, null);
  }

  /**
   * Constructs a new token for the specified kind and image.
   * <p>
   * This constructor initializes a {@code Token} with the specified kind and image, representing
   * the type and the string representation of the token, respectively.
   * </p>
   *
   * @param kind The kind of token.
   * @param image The string representation of the token.
   */
  public Token(int kind, String image) {
      this.kind = kind;
      this.image = image;
  }

  /**
   * Returns the image.
   */
  @Override
public String toString()
  {
    return image;
  }

  /**
   * Returns a new Token object, by default. However, if you want, you
   * can create and return subclass objects based on the value of ofKind.
   * Simply add the cases to the switch for all those special cases.
   * For example, if you have a subclass of Token called IDToken that
   * you want to create if ofKind is ID, simply add something like :
   *
   *    case MyParserConstants.ID : return new IDToken(ofKind, image);
   *
   * to the following switch statement. Then you can cast matchedToken
   * variable to the appropriate type and use sit in your lexical actions.

   *
   * @param ofKind the kind
   * @param image the image
   * @return Returns a new Token object, by default
   */
  public static Token newToken(int ofKind, String image)
  {
    switch(ofKind)
    {
      default : return new Token(ofKind, image);
    }
  }

  /**
   *
   * Return new token
   * @param ofKind the kinf
   * @return new token
   */
  public static Token newToken(int ofKind)
  {
    return newToken(ofKind, null);
  }

}
/* JavaCC - OriginalChecksum=37733f4d77b678122f81052c79269c4c (do not edit this line) */
