/**
 * Classes in this package relate to modelling of financial investment
 * portfolios, and Modern Portfolio Theory.
 * <ul><li>
 * An asset is a resource with economic value, and something that can
 * be owned.
 * </li><li>
 * A portfolio is a collection of something (anything).
 * </li><li>
 * An instrument is a tool or device - an enabler.
 * </li><li>
 * Financial instruments enable financial transactions, and are defined
 * in terms of assets. A financial instrument can for instance be
 * evidence of ownership of, or a contractual right/obligation to receive
 * or deliver, an asset. Financial instruments are often assets
 * themselves as they can be owned/traded.
 * </li><li>
 * Financial portfolios contain financial instruments. Typically, in
 * terms of investments, it is a collection of assets with a common owner.
 * </li><li>
 * A portfolio is also an asset... Any asset can be viewed as a portfolio
 * containing only itself.
 * </li><li>
 * Here the term portfolio represents the collection and ownership, and the term
 * asset represents components/contents and underlying value. The term
 * instrument is not used here.
 * </li></ul>
 */
package org.ojalgo.finance.portfolio;