/* Generated By:JJTree&JavaCC: Do not edit this line. ASPParserTokenManager.java */
/*
 *  This file is part of "TweetyProject", a collection of Java libraries for
 *  logical aspects of artificial intelligence and knowledge representation.
 *
 *  TweetyProject is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  Copyright 2018 The TweetyProject Team <http://tweetyproject.org/contact/>
 */
package org.tweetyproject.lp.asp.parser;

/* Generated By:JJTree: Do not edit this line. ASTAggregate.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=false,NODE_PREFIX=AST,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
/**
 *
/**
 * Represents an aggregate node in the abstract syntax tree (AST) for ASP parsing.
 *
 * <p>
 * The {@code ASTAggregate} class extends {@link SimpleNode} and is used to represent
 * aggregates in the ASP (Answer Set Programming) language.
 * Aggregates are typically used for operations such as counting, summing, or minimizing/maximizing values
 * in logic programs.
 * </p>
 *
 * @author Anna Gessler
 */
public class ASTAggregate extends SimpleNode {

    /** The aggregate function to be applied (e.g., "SUM", "COUNT"). */
    public String func;

    /**
     * Constructs a new {@code ASTAggregate} node with the given ID.
     *
     * @param id the ID of the node.
     */
    public ASTAggregate(int id) {
        super(id);
    }

    /**
     * Constructs a new {@code ASTAggregate} node with the given parser and ID.
     *
     * @param p the parser that created this node.
     * @param id the ID of the node.
     */
    public ASTAggregate(ASPParser p, int id) {
        super(p, id);
    }

    /**
     * Sets the aggregate function.
     *
     * @param f the function name (e.g., "SUM", "COUNT").
     */
    public void func(String f) {
        this.func = f;
    }

    /**
     * Accepts a visitor that conforms to the {@link ASPParserVisitor} interface.
     *
     * <p>
     * This method is used in the visitor pattern to perform external operations
     * on this node during a traversal of the AST.
     * </p>
     *
     * @param visitor the visitor to accept.
     * @param data additional data for the visitor.
     * @return the result of the visitor's operation.
     */
    public Object jjtAccept(ASPParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}
